/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.registry.notification.webhook.acr;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Util;
import hudson.model.Cause;
import hudson.model.ParameterValue;
import hudson.model.StringParameterValue;
import java.util.HashSet;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.registry.notification.webhook.PushNotification;
import org.jenkinsci.plugins.registry.notification.webhook.acr.ACRWebHookCause;
import org.jenkinsci.plugins.registry.notification.webhook.acr.ACRWebHookPayload;

public class ACRPushNotification
extends PushNotification {
    public static final String KEY_REPO_NAME = "DOCKER_TRIGGER_REPO_NAME";
    public static final String KEY_DOCKER_REGISTRY_HOST = "DOCKER_TRIGGER_DOCKER_REGISTRY_HOST";
    public static final String KEY_TAG = "DOCKER_TRIGGER_TAG";
    private String registryHost;
    private String tag;

    public ACRPushNotification(ACRWebHookPayload webHookPayload, String repoName) {
        super(webHookPayload);
        JSONObject target;
        JSONObject data;
        if (webHookPayload != null && (data = webHookPayload.getData()) != null && (target = data.getJSONObject("target")) != null) {
            this.tag = target.optString("tag");
        }
        this.repoName = repoName;
    }

    @Override
    @CheckForNull
    public String getRegistryHost() {
        return this.registryHost;
    }

    public void setRegistryHost(String registryHost) {
        this.registryHost = registryHost;
    }

    public String getTag() {
        return this.tag;
    }

    @Override
    public Cause getCause() {
        return new ACRWebHookCause(this);
    }

    @Override
    public Set<ParameterValue> getRunParameters() {
        HashSet<ParameterValue> parameters = new HashSet<ParameterValue>();
        parameters.add((ParameterValue)new StringParameterValue(KEY_REPO_NAME, this.getRepoName()));
        parameters.add((ParameterValue)new StringParameterValue(KEY_TAG, this.getTag()));
        String host = this.getRegistryHost();
        if (!StringUtils.isBlank((String)host)) {
            parameters.add((ParameterValue)new StringParameterValue(KEY_DOCKER_REGISTRY_HOST, host));
        }
        return parameters;
    }

    @Override
    public String getCauseMessage() {
        return "Docker image " + this.getRepoName() + " has been rebuilt by ACR@" + this.getRegistryHost();
    }

    @Override
    public String sha() {
        return Util.getDigestOf((String)("acrNotification:" + this.repoName + Long.toBinaryString(this.getReceived())));
    }

    @Override
    public String getShortDescription() {
        return String.format("push of %s to ACR@%s", this.getRepoName(), this.getRegistryHost());
    }
}

