/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.registry.notification.webhook;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.registry.notification.webhook.PushNotification;

public abstract class WebHookPayload
implements Serializable {
    public static final String PREFIX = "DOCKER_TRIGGER_";
    @CheckForNull
    private transient JSONObject data;
    @CheckForNull
    private String json;
    protected final long received;
    protected List<PushNotification> pushNotifications = new ArrayList<PushNotification>();

    public WebHookPayload() {
        this.received = System.currentTimeMillis();
    }

    public long getReceived() {
        return this.received;
    }

    public List<PushNotification> getPushNotifications() {
        return Collections.unmodifiableList(this.pushNotifications);
    }

    @CheckForNull
    public JSONObject getData() {
        return this.data;
    }

    protected void setData(JSONObject data) {
        this.data = data;
    }

    protected void setJson(String json) {
        this.json = json;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebHookPayload that = (WebHookPayload)o;
        if (this.received != that.received) {
            return false;
        }
        return !(this.data == null ? that.data != null : !this.data.equals((Object)that.data));
    }

    public int hashCode() {
        int result = this.data != null ? this.data.hashCode() : 0;
        result = 31 * result + (int)(this.received ^ this.received >>> 32);
        return result;
    }

    protected Object readResolve() {
        if (this.data == null && this.json != null) {
            this.data = JSONObject.fromObject((Object)this.json);
        }
        return this;
    }
}

