/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.registry.notification.token;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.PersistentDescriptor;
import hudson.util.HttpResponses;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import net.jcip.annotations.GuardedBy;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

@Extension
@Restricted(value={NoExternalUse.class})
@Symbol(value={"dockerHubApiTokens"})
public class ApiTokens
extends GlobalConfiguration
implements PersistentDescriptor {
    private static final Logger LOGGER = Logger.getLogger(ApiTokens.class.getName());
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final String HASH_ALGORITHM = "SHA-256";
    @GuardedBy(value="this")
    private final List<HashedApiToken> apiTokens = new ArrayList<HashedApiToken>();

    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    public static ApiTokens get() {
        return (ApiTokens)((Object)GlobalConfiguration.all().get(ApiTokens.class));
    }

    @POST
    public HttpResponse doGenerate(StaplerRequest req) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        String apiTokenName = req.getParameter("apiTokenName");
        JSONObject json = this.generateApiToken(apiTokenName);
        this.save();
        return HttpResponses.okJSON((JSONObject)json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject generateApiToken(@NonNull String name) {
        byte[] random = new byte[16];
        RANDOM.nextBytes(random);
        String plainTextApiToken = Util.toHexString((byte[])random);
        assert (plainTextApiToken.length() == 32);
        String apiTokenValueHashed = Util.toHexString((byte[])ApiTokens.hashedBytes(plainTextApiToken.getBytes(StandardCharsets.US_ASCII)));
        HashedApiToken apiToken = new HashedApiToken(name, apiTokenValueHashed);
        ApiTokens apiTokens = this;
        synchronized (apiTokens) {
            this.apiTokens.add(apiToken);
        }
        JSONObject json = new JSONObject();
        json.put("uuid", (Object)apiToken.getUuid());
        json.put("name", (Object)apiToken.getName());
        json.put("value", (Object)plainTextApiToken);
        return json;
    }

    @NonNull
    private static byte[] hashedBytes(byte[] tokenBytes) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(HASH_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError("There is no SHA-256 available in this system", e);
        }
        return digest.digest(tokenBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    public HttpResponse doRevoke(StaplerRequest req) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        String apiTokenUuid = req.getParameter("apiTokenUuid");
        if (StringUtils.isBlank((String)apiTokenUuid)) {
            return HttpResponses.errorWithoutStack((int)400, (String)"API token UUID cannot be empty");
        }
        ApiTokens apiTokens = this;
        synchronized (apiTokens) {
            this.apiTokens.removeIf(apiToken -> apiToken.getUuid().equals(apiTokenUuid));
        }
        this.save();
        return HttpResponses.ok();
    }

    public synchronized Collection<HashedApiToken> getApiTokens() {
        return Collections.unmodifiableList(new ArrayList<HashedApiToken>(this.apiTokens));
    }

    public boolean isValidApiToken(String plainApiToken) {
        if (StringUtils.isBlank((String)plainApiToken)) {
            return false;
        }
        return this.hasMatchingApiToken(plainApiToken);
    }

    public synchronized boolean hasMatchingApiToken(@NonNull String plainApiToken) {
        byte[] hash = ApiTokens.hashedBytes(plainApiToken.getBytes(StandardCharsets.US_ASCII));
        return this.apiTokens.stream().anyMatch(apiToken -> ((HashedApiToken)apiToken).match(hash));
    }

    public static class HashedApiToken
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String uuid;
        private final String name;
        private final String hash;
        private final Date created;

        private HashedApiToken(String name, String hash) {
            this.uuid = UUID.randomUUID().toString();
            this.name = name;
            this.hash = hash;
            this.created = new Date();
        }

        private HashedApiToken(String uuid, String name, String hash, Date created) {
            this.uuid = uuid;
            this.name = name;
            this.hash = hash;
            this.created = created;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getName() {
            return this.name;
        }

        public String getHash() {
            return this.hash;
        }

        public Date getCreated() {
            return new Date(this.created.getTime());
        }

        private boolean match(byte[] hashedBytes) {
            byte[] hashFromHex;
            try {
                hashFromHex = Util.fromHexString((String)this.hash);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "The API token with name=[{0}] is not in hex-format and so cannot be used", this.name);
                return false;
            }
            return MessageDigest.isEqual(hashFromHex, hashedBytes);
        }
    }
}

