/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.registry.notification;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Job;
import hudson.model.Project;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.jenkinsci.plugins.docker.commons.DockerImageExtractor;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterial;
import org.jenkinsci.plugins.registry.notification.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class DockerPullImageBuilder
extends Builder {
    private final String image;
    private final DockerRegistryEndpoint registry;

    @DataBoundConstructor
    public DockerPullImageBuilder(DockerRegistryEndpoint registry, String image) {
        this.image = image;
        this.registry = registry;
    }

    public String getImage() {
        return this.image;
    }

    public DockerRegistryEndpoint getRegistry() {
        return this.registry;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        int status = 0;
        KeyMaterial key = null;
        EnvVars env = build.getEnvironment((TaskListener)listener);
        String expandedImage = env.expand(this.image);
        try {
            key = this.registry.newKeyMaterialFactory(build).materialize();
            status = launcher.launch().cmds(new String[]{"docker", "pull", this.registry.imageName(expandedImage)}).envs((Map)key.env()).writeStdin().stdout((OutputStream)listener.getLogger()).stderr((OutputStream)listener.getLogger()).join();
            if (status != 0) {
                throw new RuntimeException("Failed to pull docker image");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to pull docker image", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to pull docker image", e);
        }
        finally {
            if (key != null) {
                key.close();
            }
        }
        listener.getLogger().println("docker pull " + this.image);
        return true;
    }

    @Extension
    public static final class ImageExtractor
    extends DockerImageExtractor {
        @NonNull
        public Collection<String> getDockerImagesUsedByJob(@NonNull Job<?, ?> job) {
            if (job instanceof Project) {
                Project project = (Project)job;
                HashSet<String> images = new HashSet<String>();
                for (Builder b : project.getBuilders()) {
                    if (!(b instanceof DockerPullImageBuilder)) continue;
                    images.add(((DockerPullImageBuilder)b).getImage());
                }
                return images;
            }
            return Collections.emptySet();
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.DockerPullImageBuilder_DisplayName();
        }
    }
}

