/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer.targets;

import com.cloudbees.plugins.deployer.sources.DeploySource;
import com.cloudbees.plugins.deployer.sources.DeploySourceDescriptor;
import com.cloudbees.plugins.deployer.sources.DeploySourceOrigin;
import com.cloudbees.plugins.deployer.targets.DeployTarget;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class DeployTargetDescriptor<T extends DeployTarget<T>>
extends Descriptor<T> {
    protected DeployTargetDescriptor() {
    }

    protected DeployTargetDescriptor(@NonNull Class<? extends T> clazz) {
        super(clazz);
    }

    public boolean isFileTarget() {
        return true;
    }

    public boolean isDirectoryTarget() {
        return false;
    }

    @NonNull
    public DescriptorExtensionList<DeploySource, Descriptor<DeploySource>> getDeploySourceDescriptors() {
        return Hudson.getInstance().getDescriptorList(DeploySource.class);
    }

    @NonNull
    public List<DeploySourceDescriptor> getDeploySourceDescriptors(@CheckForNull Set<DeploySourceOrigin> origins, @CheckForNull Class<? extends AbstractProject> jobType) {
        ArrayList<DeploySourceDescriptor> result = new ArrayList<DeploySourceDescriptor>();
        if (origins != null) {
            block0: for (Descriptor d : Hudson.getInstance().getDescriptorList(DeploySource.class)) {
                if (!(d instanceof DeploySourceDescriptor)) continue;
                DeploySourceDescriptor descriptor = (DeploySourceDescriptor)d;
                for (DeploySourceOrigin source : origins) {
                    if (!descriptor.isSupported(source) || !descriptor.isApplicable(jobType)) continue;
                    if ((!this.isFileTarget() || !descriptor.isFileSource()) && (!this.isDirectoryTarget() || !descriptor.isDirectorySource())) continue block0;
                    result.add(descriptor);
                    continue block0;
                }
            }
        }
        return result;
    }

    @CheckForNull
    public DeploySource defaultDeploySource(@CheckForNull DeploySource source, @CheckForNull Set<DeploySourceOrigin> origins, @CheckForNull Class<? extends AbstractProject> jobType) {
        if (source != null) {
            return source;
        }
        if (origins != null) {
            for (Descriptor d : Hudson.getInstance().getDescriptorList(DeploySource.class)) {
                if (!(d instanceof DeploySourceDescriptor)) continue;
                DeploySourceDescriptor descriptor = (DeploySourceDescriptor)d;
                for (DeploySourceOrigin origin : origins) {
                    if (!descriptor.isSupported(origin) || !descriptor.isApplicable(jobType) || (!this.isFileTarget() || !descriptor.isFileSource()) && (!this.isDirectoryTarget() || !descriptor.isDirectorySource())) continue;
                    try {
                        return descriptor.newInstance();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                    }
                }
            }
        }
        return null;
    }

    public FormValidation validateFilePath(String filePathName, FilePath filePath) throws IOException, InterruptedException {
        return FormValidation.ok();
    }
}

