/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer.sources;

import com.cloudbees.plugins.deployer.DeployNowProjectAction;
import com.cloudbees.plugins.deployer.DeployNowRunAction;
import com.cloudbees.plugins.deployer.resolvers.CapabilitiesResolver;
import com.cloudbees.plugins.deployer.sources.DeploySource;
import com.cloudbees.plugins.deployer.sources.DeploySourceOrigin;
import com.cloudbees.plugins.deployer.targets.DeployTargetDescriptor;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.FilePath;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.maven.project.MavenProject;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public abstract class DeploySourceDescriptor
extends Descriptor<DeploySource> {
    public static boolean isMavenJob(Class<? extends AbstractProject> jobType) {
        return jobType != null && (MavenModuleSet.class.isAssignableFrom(jobType) || MavenProject.class.isAssignableFrom(jobType) || MavenModule.class.isAssignableFrom(jobType));
    }

    public boolean isApplicable(@CheckForNull Class<? extends AbstractProject> jobType) {
        return true;
    }

    public abstract boolean isSupported(@CheckForNull DeploySourceOrigin var1);

    public boolean isSupported(DeploySourceOrigin ... origins) {
        for (DeploySourceOrigin origin : origins) {
            if (!this.isSupported(origin)) continue;
            return true;
        }
        return false;
    }

    public boolean isFileSource() {
        return true;
    }

    public boolean isDirectorySource() {
        return false;
    }

    @CheckForNull
    protected Run findRun() {
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request == null) {
            return null;
        }
        List ancestors = request.getAncestors();
        for (int i = ancestors.size() - 1; i >= 0; --i) {
            Ancestor a = (Ancestor)ancestors.get(i);
            Object object = a.getObject();
            if (object instanceof DeployNowRunAction) {
                return ((DeployNowRunAction)object).getOwner();
            }
            if (object instanceof DeployNowProjectAction) {
                return CapabilitiesResolver.getLastDeployableBuild(((DeployNowProjectAction)object).getOwner());
            }
            if (object instanceof Run) {
                return (Run)object;
            }
            if (!(object instanceof Job)) continue;
            return CapabilitiesResolver.getLastDeployableBuild((Job)object);
        }
        return null;
    }

    @CheckForNull
    protected Job findJob() {
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request == null) {
            return null;
        }
        List ancestors = request.getAncestors();
        for (int i = ancestors.size() - 1; i >= 0; --i) {
            Ancestor a = (Ancestor)ancestors.get(i);
            Object object = a.getObject();
            if (object instanceof DeployNowRunAction) {
                return null;
            }
            if (object instanceof DeployNowProjectAction) {
                return null;
            }
            if (object instanceof Run) {
                return null;
            }
            if (!(object instanceof Job)) continue;
            return (Job)object;
        }
        return null;
    }

    public DeploySource newInstance() {
        throw new UnsupportedOperationException();
    }

    protected FormValidation delegatePathValidationToTarget(@CheckForNull String pathName, @CheckForNull String targetDescriptorId, @CheckForNull FilePath path) throws IOException, InterruptedException {
        Descriptor o;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null && path != null && (o = jenkins.getDescriptorByName(targetDescriptorId)) instanceof DeployTargetDescriptor) {
            DeployTargetDescriptor d = (DeployTargetDescriptor)o;
            if (d.clazz.getName().equals(targetDescriptorId)) {
                return d.validateFilePath(pathName, path);
            }
        }
        return FormValidation.ok();
    }
}

