/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer;

import com.cloudbees.plugins.deployer.DeployNowSlave;
import com.cloudbees.plugins.deployer.DeployNowTask;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Slave;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import hudson.util.Futures;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.LogRecord;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class DeployNowComputer
extends SlaveComputer {
    public static final DeployNowRetentionStrategy RETENTION_STRATEGY = new DeployNowRetentionStrategy();
    private volatile boolean offline = false;

    public DeployNowComputer(DeployNowSlave node) {
        super((Slave)node);
    }

    public boolean isOffline() {
        return this.offline;
    }

    public Charset getDefaultCharset() {
        return Charset.defaultCharset();
    }

    public List<LogRecord> getLogRecords() throws IOException, InterruptedException {
        return Hudson.logRecords;
    }

    public HttpResponse doDoDelete() throws IOException {
        throw HttpResponses.forwardToView((Object)((Object)this), (String)"index");
    }

    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        throw HttpResponses.forwardToView((Object)((Object)this), (String)"index");
    }

    public void doLaunchSlaveAgent(StaplerRequest req, StaplerResponse rsp) throws IOException {
        rsp.sendError(404);
    }

    protected Future<?> _connect(boolean forceReconnect) {
        return Futures.precomputed(null);
    }

    public boolean isConnecting() {
        return false;
    }

    public RetentionStrategy getRetentionStrategy() {
        return RETENTION_STRATEGY;
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        this.checkLater();
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        this.checkLater();
    }

    public Map<String, Object> getMonitorData() {
        Computer computer = Hudson.getInstance().toComputer();
        return computer == null ? super.getMonitorData() : computer.getMonitorData();
    }

    private void checkLater() {
        Computer.threadPoolForRemoting.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                RETENTION_STRATEGY.check(DeployNowComputer.this);
            }
        });
    }

    public static class DeployNowRetentionStrategy
    extends RetentionStrategy<DeployNowComputer> {
        public synchronized long check(DeployNowComputer c) {
            if (!c.isIdle()) {
                return 1L;
            }
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins != null) {
                for (Queue.Item t : jenkins.getQueue().getItems()) {
                    if (!(t.task instanceof DeployNowTask)) continue;
                    return 1L;
                }
            }
            if (!c.offline) {
                c.offline = true;
                try {
                    Slave node;
                    if (jenkins != null && (node = c.getNode()) != null) {
                        jenkins.removeNode((Node)node);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return 1L;
        }

        public synchronized DeployNowSlave ensurePresent() {
            for (Node n : Hudson.getInstance().getNodes()) {
                if (!(n instanceof DeployNowSlave)) continue;
                DeployNowSlave deployNowSlave = (DeployNowSlave)n;
                DeployNowComputer computer = (DeployNowComputer)deployNowSlave.getComputer();
                if (computer != null && computer.offline) {
                    computer.offline = false;
                }
                if (!Hudson.getInstance().getNodes().contains((Object)deployNowSlave)) continue;
                return deployNowSlave;
            }
            try {
                DeployNowSlave n = new DeployNowSlave();
                Hudson.getInstance().addNode((Node)n);
                return n;
            }
            catch (IOException e) {
                return null;
            }
            catch (Descriptor.FormException e) {
                return null;
            }
        }
    }
}

