/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer.hosts;

import com.cloudbees.plugins.deployer.hosts.DeployHostDescriptor;
import com.cloudbees.plugins.deployer.resolvers.CapabilitiesResolver;
import com.cloudbees.plugins.deployer.sources.DeploySourceOrigin;
import com.cloudbees.plugins.deployer.targets.DeployTarget;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.security.ACL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.acegisecurity.Authentication;

public abstract class DeployHost<S extends DeployHost<S, T>, T extends DeployTarget<T>>
extends AbstractDescribableImpl<DeployHost<S, T>> {
    @NonNull
    private final List<T> targets;

    protected DeployHost(@CheckForNull List<T> targets) {
        this.targets = Collections.unmodifiableList(new ArrayList(targets == null ? Collections.emptyList() : targets));
    }

    public static boolean isValid(List<? extends DeployHost<?, ?>> sets, Run<?, ?> owner, Authentication authentication) {
        for (DeployHost<?, ?> set : sets) {
            if (set.isValid(owner, authentication)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(List<? extends DeployHost<?, ?>> sets, AbstractProject<?, ?> owner, Authentication authentication) {
        for (DeployHost<?, ?> set : sets) {
            if (set.isValid(owner, authentication)) continue;
            return false;
        }
        return true;
    }

    @NonNull
    public final List<T> getTargets() {
        return this.targets;
    }

    public final boolean isValid(AbstractProject<?, ?> project, Authentication authentication) {
        Run<?, ?> lastSuccessfulBuild = CapabilitiesResolver.of(project).getLastSuccessfulBuild(project);
        return lastSuccessfulBuild != null && this.isValid(lastSuccessfulBuild, authentication);
    }

    public final boolean isValid(AbstractProject<?, ?> project) {
        return this.isValid(project, ACL.SYSTEM);
    }

    public final boolean isValid(Run<?, ?> run) {
        return this.isValid(run, ACL.SYSTEM);
    }

    public final boolean isValid(Run<?, ?> run, Authentication authentication) {
        if (!this.isAuthenticationValid(authentication)) {
            return false;
        }
        for (DeployTarget target : this.targets) {
            if (target.isValid(run)) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean isAuthenticationValid(Authentication var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DeployHost");
        sb.append("{targets=").append(this.targets);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DeployHost deployHost = (DeployHost)((Object)o);
        return this.targets.equals(deployHost.targets);
    }

    public int hashCode() {
        return this.targets.hashCode();
    }

    public abstract String getDisplayName();

    public DeployHostDescriptor<S, T> getDescriptor() {
        return (DeployHostDescriptor)super.getDescriptor();
    }

    public static List<DeployHost<?, ?>> createDefaults(@CheckForNull AbstractProject<?, ?> owner, @CheckForNull Set<DeploySourceOrigin> origins) {
        return DeployHost.createDefaults(CapabilitiesResolver.of(owner).getLastSuccessfulBuild(owner), origins);
    }

    @CheckForNull
    public static List<DeployHost<?, ?>> createDefaults(@CheckForNull Run<?, ?> run, @CheckForNull Set<DeploySourceOrigin> origins) {
        ArrayList result = new ArrayList();
        for (DeployHostDescriptor d : DeployHostDescriptor.all()) {
            Object set;
            if (!d.isSupported(origins, run) || (set = d.createDefault(run, origins)) == null) continue;
            result.add((DeployHost<?, ?>)((Object)set));
        }
        return result;
    }

    public static List<DeployHost<?, ?>> updateDefaults(@CheckForNull AbstractProject<?, ?> owner, @CheckForNull Set<DeploySourceOrigin> origins, List<? extends DeployHost<?, ?>> templates) {
        return DeployHost.updateDefaults(CapabilitiesResolver.of(owner).getLastSuccessfulBuild(owner), origins, templates);
    }

    @CheckForNull
    public static List<DeployHost<?, ?>> updateDefaults(@CheckForNull Run<?, ?> run, @CheckForNull Set<DeploySourceOrigin> origins, List<? extends DeployHost<?, ?>> templates) {
        ArrayList result = new ArrayList();
        ArrayList remaining = new ArrayList((Collection<DeployHostDescriptor<?, ?>>)DeployHostDescriptor.all());
        for (DeployHost<?, ?> deployHost : templates) {
            DeployHost<Object, Object> set;
            if (deployHost == null) continue;
            Descriptor d = deployHost.getDescriptor();
            remaining.remove(d);
            if (!d.isSupported(origins, run) || (set = deployHost.getTargets().isEmpty() ? super.updateDefault(run, origins) : deployHost) == null) continue;
            result.add(set);
        }
        if (result.isEmpty()) {
            for (DeployHostDescriptor deployHostDescriptor : remaining) {
                Object set;
                if (!deployHostDescriptor.isSupported(origins, run) || (set = deployHostDescriptor.createDefault(run, origins)) == null) continue;
                result.add((DeployHost<?, ?>)((Object)set));
            }
        }
        return result;
    }

    private S updateDefault(Run<?, ?> run, Set<DeploySourceOrigin> origins) {
        return (S)((Object)this.getDescriptor().updateDefault(run, origins, this));
    }
}

