/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer;

import com.cloudbees.plugins.deployer.DeployNowColumn;
import com.cloudbees.plugins.deployer.DeployNowJobProperty;
import com.cloudbees.plugins.deployer.DeployNowRunAction;
import com.cloudbees.plugins.deployer.Messages;
import com.cloudbees.plugins.deployer.hosts.DeployHost;
import com.cloudbees.plugins.deployer.hosts.DeployHostsContext;
import com.cloudbees.plugins.deployer.resolvers.CapabilitiesResolver;
import com.cloudbees.plugins.deployer.sources.DeploySourceOrigin;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.util.HttpResponses;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class DeployNowProjectAction
implements Action {
    private final AbstractProject<?, ?> owner;
    public static final Permission CONFIGURE = DeployNowRunAction.CONFIGURE;
    public static final Permission DEPLOY = DeployNowRunAction.DEPLOY;
    public static final Permission OWN_AUTH = DeployNowRunAction.OWN_AUTH;
    public static final Permission JOB_AUTH = DeployNowRunAction.JOB_AUTH;

    public DeployNowProjectAction(AbstractProject<?, ?> owner) {
        this.owner = owner;
    }

    public String getIconFileName() {
        return DeployNowColumn.DescriptorImpl.isDeployPossible(this.owner) ? Jenkins.RESOURCE_PATH + "/plugin/deployer-framework/images/24x24/deploy-now.png" : null;
    }

    public String getDisplayName() {
        return Messages.DeployNowProjectAction_DisplayName();
    }

    public Set<DeploySourceOrigin> getSources() {
        return Collections.singleton(DeploySourceOrigin.RUN);
    }

    public String getUrlName() {
        return "deploy-now";
    }

    public AbstractProject<?, ?> getOwner() {
        return this.owner;
    }

    @CheckForNull
    public AbstractBuild<?, ?> getLastDeployableBuild() {
        return (AbstractBuild)AbstractBuild.class.cast(CapabilitiesResolver.getLastDeployableBuild(this.owner));
    }

    public DeployHostsContext<DeployNowProjectAction> createHostsContext() {
        DeployNowJobProperty property;
        List<DeployHost<?, ?>> sets = null;
        if (this.owner != null && (property = (DeployNowJobProperty)this.owner.getProperty(DeployNowJobProperty.class)) != null) {
            sets = property.getHosts();
            sets = DeployHost.updateDefaults(this.owner, Collections.singleton(DeploySourceOrigin.RUN), sets);
        }
        if (sets == null) {
            sets = DeployHost.createDefaults(this.owner, Collections.singleton(DeploySourceOrigin.RUN));
        }
        return new DeployHostsContext<DeployNowProjectAction>(this, sets, (Job<?, ?>)this.owner, Collections.singleton(DeploySourceOrigin.RUN), false, true);
    }

    @Exported(name="oneClickDeployPossible", visibility=2)
    public boolean isOneClickDeployPossible() {
        return DeployNowColumn.DescriptorImpl.isDeployPossible(this.owner);
    }

    @Exported(name="oneClickDeployReady", visibility=2)
    public boolean isOneClickDeploy() {
        DeployNowJobProperty property;
        if (this.owner != null && (property = (DeployNowJobProperty)this.owner.getProperty(DeployNowJobProperty.class)) != null) {
            return property.isOneClickDeploy();
        }
        return true;
    }

    @Exported(name="oneClickDeployValid", visibility=2)
    public boolean isOneClickDeployValid() {
        DeployNowJobProperty property;
        if (this.owner != null && this.owner.hasPermission(DEPLOY) && (property = (DeployNowJobProperty)this.owner.getProperty(DeployNowJobProperty.class)) != null && property.isOneClickDeploy()) {
            if (this.owner.hasPermission(OWN_AUTH) && DeployHost.isValid(property.getHosts(), this.owner, Hudson.getAuthentication())) {
                return true;
            }
            if (this.owner.hasPermission(JOB_AUTH) && DeployHost.isValid(property.getHosts(), this.owner, ACL.SYSTEM)) {
                return true;
            }
        }
        return false;
    }

    public boolean isSaveConfigForced() {
        if (this.owner != null) {
            DeployNowJobProperty property = (DeployNowJobProperty)this.owner.getProperty(DeployNowJobProperty.class);
            return property == null;
        }
        return false;
    }

    public HttpResponse doIndex(StaplerRequest req) {
        if (!DeployNowColumn.DescriptorImpl.isDeployPossible(this.owner)) {
            return HttpResponses.notFound();
        }
        return HttpResponses.forwardToView((Object)this, (String)"configure");
    }

    public DeployNowJobProperty.DescriptorImpl getDescriptor() {
        return (DeployNowJobProperty.DescriptorImpl)Hudson.getInstance().getDescriptor(DeployNowJobProperty.class);
    }
}

