/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer;

import com.cloudbees.plugins.deployer.DeployNowProjectAction;
import com.cloudbees.plugins.deployer.Messages;
import com.cloudbees.plugins.deployer.NamedThreadFactory;
import com.cloudbees.plugins.deployer.hosts.DeployHost;
import com.cloudbees.plugins.deployer.hosts.DeployHostsContext;
import com.cloudbees.plugins.deployer.resolvers.CapabilitiesResolver;
import com.cloudbees.plugins.deployer.sources.DeploySourceOrigin;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.TransientProjectActionFactory;
import hudson.util.ExceptionCatchingThreadFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class DeployNowJobProperty
extends JobProperty<AbstractProject<?, ?>> {
    private boolean oneClickDeploy;
    private List<? extends DeployHost<?, ?>> hosts;

    @DataBoundConstructor
    public DeployNowJobProperty(boolean oneClickDeploy, List<? extends DeployHost<?, ?>> hosts) {
        this.hosts = new ArrayList(hosts == null ? Collections.emptySet() : hosts);
        this.oneClickDeploy = oneClickDeploy;
    }

    static void submit(Runnable task) {
        Descriptor descriptor = Jenkins.get().getDescriptor(DeployNowJobProperty.class);
        if (descriptor instanceof DescriptorImpl) {
            ((DescriptorImpl)descriptor).deployNowPool.submit(task);
        }
    }

    public boolean isOneClickDeploy() {
        return this.oneClickDeploy;
    }

    public void setOneClickDeploy(boolean oneClickDeploy) {
        this.oneClickDeploy = oneClickDeploy;
    }

    public List<? extends DeployHost<?, ?>> getHosts() {
        return this.hosts == null ? DeployHost.createDefaults((AbstractProject)this.owner, Collections.singleton(DeploySourceOrigin.RUN)) : this.hosts;
    }

    public void setHosts(List<? extends DeployHost<?, ?>> hosts) {
        this.hosts = hosts;
    }

    public Collection<? extends Action> getJobActions(AbstractProject<?, ?> job) {
        return Arrays.asList(new DeployNowProjectAction(job));
    }

    @Extension
    public static class TransientProjectActionFactoryImpl
    extends TransientProjectActionFactory {
        public Collection<? extends Action> createFor(AbstractProject target) {
            if (target.getProperty(DeployNowJobProperty.class) == null) {
                return Arrays.asList(new DeployNowProjectAction(target));
            }
            return Collections.emptySet();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public final ExecutorService deployNowPool = new ThreadPoolExecutor(0, 2, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("DeployNowWorkers", (ThreadFactory)new ExceptionCatchingThreadFactory(Executors.defaultThreadFactory())));

        public String getDisplayName() {
            return Messages.DeployNowJobProperty_DisplayName();
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return super.newInstance(req, formData);
        }

        public DeployNowJobProperty getInstance(AbstractProject<?, ?> project) {
            DeployNowJobProperty property = (DeployNowJobProperty)project.getProperty(DeployNowJobProperty.class);
            if (property != null) {
                return property;
            }
            return new DeployNowJobProperty(false, DeployHost.createDefaults(project, CapabilitiesResolver.of(project).getInstantSources(project)));
        }

        public Set<DeploySourceOrigin> getSources() {
            AbstractProject project = (AbstractProject)Stapler.getCurrentRequest().findAncestorObject(AbstractProject.class);
            if (project != null) {
                return CapabilitiesResolver.of(project).getInstantSources(project);
            }
            return Collections.singleton(DeploySourceOrigin.RUN);
        }

        public DeployHostsContext<AbstractProject<?, ?>> createHostsContext(AbstractProject<?, ?> it, DeployNowJobProperty instance) {
            CapabilitiesResolver resolver = CapabilitiesResolver.of(it);
            return new DeployHostsContext(it, instance == null ? DeployHost.createDefaults(it, resolver.getInstantSources(it)) : instance.getHosts(), (Job<?, ?>)it, resolver.getInstantSources(it), false, true);
        }
    }
}

