/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.depgraph_view.model.layout;

import edu.uci.ics.jung.algorithms.layout.AbstractLayout;
import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JungSugiyama<V, E>
extends AbstractLayout<V, E> {
    private static final Orientation DEFAULT_ORIENTATION = Orientation.TOP;
    private static final int DEFAULT_HORIZONTAL_SPACING = 200;
    private static final int DEFAULT_VERTICAL_SPACING = 100;
    private boolean executed = false;
    private int gridAreaSize = Integer.MIN_VALUE;
    private int horzSpacing;
    private int vertSpacing;
    private Map<V, CellWrapper<V>> vertToWrapper = new HashMap<V, CellWrapper<V>>();
    private Orientation orientation;

    public JungSugiyama(Graph<V, E> g) {
        this(g, DEFAULT_ORIENTATION, 200, 100);
    }

    public JungSugiyama(Graph<V, E> g, Orientation orientation, int horzSpacing, int vertSpacing) {
        super(JungSugiyama.copyGraph(g));
        this.orientation = orientation;
        this.horzSpacing = horzSpacing;
        this.vertSpacing = vertSpacing;
    }

    private static <V, E> Graph<V, E> copyGraph(Graph<V, E> src) {
        try {
            Graph dest = (Graph)src.getClass().newInstance();
            for (Object v : src.getVertices()) {
                dest.addVertex(v);
            }
            for (Object e : src.getEdges()) {
                dest.addEdge(e, src.getIncidentVertices(e));
            }
            return dest;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void initialize() {
        if (!this.executed) {
            List<List<CellWrapper<V>>> graphLevels = this.runSugiyama();
            for (List<CellWrapper<V>> level : graphLevels) {
                for (CellWrapper<V> wrapper : level) {
                    V vertex = wrapper.getVertexView();
                    if (this.orientation.equals((Object)Orientation.TOP)) {
                        double xCoordinate = 10.0 + (double)(((CellWrapper)wrapper).gridPosition * this.horzSpacing);
                        double yCoordinate = 10.0 + (double)(((CellWrapper)wrapper).level * this.vertSpacing);
                        this.setLocation(vertex, xCoordinate, yCoordinate);
                        continue;
                    }
                    double yCoordinate = 10.0 + (double)(((CellWrapper)wrapper).gridPosition * this.vertSpacing);
                    double xCoordinate = 10.0 + (double)(((CellWrapper)wrapper).level * this.horzSpacing);
                    this.setLocation(vertex, xCoordinate, yCoordinate);
                }
            }
        }
    }

    public String toString() {
        return "Jung Sugiyama";
    }

    private List<List<CellWrapper<V>>> runSugiyama() {
        this.executed = true;
        HashSet vertexSet = new HashSet(this.graph.getVertices());
        this.makeGraphAcyclic();
        List<List<CellWrapper<V>>> levels = this.fillLevels();
        levels = this.balanceLevels(levels);
        this.solveEdgeCrosses(levels);
        this.moveToBarycenter(levels, vertexSet);
        return levels;
    }

    private void makeGraphAcyclic() {
        new AcyclicCalculator().run();
    }

    private List<List<CellWrapper<V>>> fillLevels() {
        return this.fillLevels(0, JungSugiyama.copyGraph(this.graph), new LinkedList<List<CellWrapper<V>>>());
    }

    private List<List<CellWrapper<V>>> fillLevels(int currentLevel, Graph<V, E> graph, List<List<CellWrapper<V>>> levels) {
        if (graph.getVertices().isEmpty()) {
            return levels;
        }
        List<V> roots = this.searchRoots(graph);
        if (levels.size() == currentLevel) {
            levels.add(currentLevel, new LinkedList());
        }
        List<CellWrapper<V>> vecForTheCurrentLevel = levels.get(currentLevel);
        for (V rootNode : roots) {
            int numberForTheEntry = vecForTheCurrentLevel.size();
            CellWrapper<V> wrapper = new CellWrapper<V>(currentLevel, numberForTheEntry, rootNode);
            vecForTheCurrentLevel.add(wrapper);
            this.vertToWrapper.put((CellWrapper<V>)rootNode, (CellWrapper<CellWrapper<V>>)wrapper);
            graph.removeVertex(rootNode);
        }
        if (vecForTheCurrentLevel.size() > this.gridAreaSize) {
            this.gridAreaSize = vecForTheCurrentLevel.size();
        }
        this.fillLevels(currentLevel + 1, graph, levels);
        return levels;
    }

    private List<V> searchRoots(Graph<V, E> graph) {
        LinkedList roots = new LinkedList();
        for (Object vert : graph.getVertices()) {
            int in_degree = graph.inDegree(vert);
            if (in_degree != 0) continue;
            roots.add(vert);
        }
        return roots;
    }

    private List<List<CellWrapper<V>>> balanceLevels(List<List<CellWrapper<V>>> levels) {
        HashMap<V, Integer> maxLevels = new HashMap<V, Integer>();
        HashMap<V, Integer> minLevels = new HashMap<V, Integer>();
        LinkedList<CellWrapper<V>> verticesToAdd = new LinkedList<CellWrapper<V>>();
        ArrayList<Integer> sizes = new ArrayList<Integer>(levels.size());
        for (List<CellWrapper<V>> list : levels) {
            for (CellWrapper<V> node : list) {
                int maxLevel;
                int minLevel = this.findMinPossibleLevel(node);
                if (minLevel == (maxLevel = this.findMaxPossibleLevel(node, levels.size()))) continue;
                maxLevels.put(node.getVertexView(), maxLevel);
                minLevels.put(node.getVertexView(), minLevel);
                verticesToAdd.add(node);
            }
            list.removeAll(verticesToAdd);
            sizes.add(list.size());
        }
        for (CellWrapper cellWrapper : verticesToAdd) {
            int minSize = Integer.MAX_VALUE;
            int minIndex = -1;
            for (int i = ((Integer)minLevels.get(cellWrapper.getVertexView())).intValue(); i <= (Integer)maxLevels.get(cellWrapper.getVertexView()); ++i) {
                if ((Integer)sizes.get(i) >= minSize) continue;
                minSize = (Integer)sizes.get(i);
                minIndex = i;
            }
            levels.get(minIndex).add(cellWrapper);
            sizes.set(minIndex, (Integer)sizes.get(minIndex) + 1);
        }
        LinkedList<List<CellWrapper<V>>> newLevels = new LinkedList<List<CellWrapper<V>>>();
        for (List<CellWrapper<V>> level : levels) {
            LinkedList<CellWrapper<V>> newLevel = new LinkedList<CellWrapper<V>>();
            for (CellWrapper<V> cellWrapper : level) {
                newLevel.add(new CellWrapper<V>(newLevels.size(), newLevel.size(), cellWrapper.getVertexView()));
            }
            newLevels.add(newLevel);
        }
        return newLevels;
    }

    private int findMaxPossibleLevel(CellWrapper<V> node, int numLevels) {
        V vertex = node.getVertexView();
        int maxLevel = numLevels - 1;
        for (Object successor : this.graph.getSuccessors(vertex)) {
            int level = this.vertToWrapper.get(successor).getLevel();
            maxLevel = Math.min(level - 1, maxLevel);
        }
        return maxLevel;
    }

    private int findMinPossibleLevel(CellWrapper<V> node) {
        V vertex = node.getVertexView();
        Collection predecessors = this.graph.getPredecessors(vertex);
        int minLevel = 0;
        for (Object predecessor : predecessors) {
            int level = this.vertToWrapper.get(predecessor).getLevel();
            minLevel = Math.max(level + 1, minLevel);
        }
        return minLevel;
    }

    private void solveEdgeCrosses(List<List<CellWrapper<V>>> levels) {
        int movementsCurrentLoop = -1;
        while (movementsCurrentLoop != 0) {
            int i;
            movementsCurrentLoop = 0;
            for (i = 0; i < levels.size() - 1; ++i) {
                movementsCurrentLoop += this.solveEdgeCrosses(true, levels, i);
            }
            for (i = levels.size() - 1; i >= 1; --i) {
                movementsCurrentLoop += this.solveEdgeCrosses(false, levels, i);
            }
        }
    }

    private int solveEdgeCrosses(boolean down, List<List<CellWrapper<V>>> levels, int levelIndex) {
        int j;
        List<CellWrapper<V>> currentLevel = levels.get(levelIndex);
        int movements = 0;
        CellWrapper[] levelSortBefore = currentLevel.toArray(new CellWrapper[0]);
        Collections.sort(currentLevel);
        for (j = 0; j < levelSortBefore.length; ++j) {
            if (levelSortBefore[j].getEdgeCrossesIndicator() == currentLevel.get(j).getEdgeCrossesIndicator()) continue;
            ++movements;
        }
        for (j = currentLevel.size() - 1; j >= 0; --j) {
            CellWrapper<V> sourceWrapper = currentLevel.get(j);
            V sourceView = sourceWrapper.getVertexView();
            Collection<E> edgeList = this.getNeighborEdges(sourceView);
            for (E edge : edgeList) {
                Object targetView = null;
                if (down && sourceView == this.graph.getSource(edge)) {
                    targetView = this.graph.getDest(edge);
                }
                if (!down && sourceView == this.graph.getDest(edge)) {
                    targetView = this.graph.getSource(edge);
                }
                if (targetView == null) continue;
                CellWrapper<V> targetWrapper = this.vertToWrapper.get(targetView);
                if (down && targetWrapper != null && targetWrapper.getLevel() > levelIndex) {
                    targetWrapper.addToEdgeCrossesIndicator(sourceWrapper.getEdgeCrossesIndicator());
                }
                if (down || targetWrapper == null || targetWrapper.getLevel() >= levelIndex) continue;
                targetWrapper.addToEdgeCrossesIndicator(sourceWrapper.getEdgeCrossesIndicator());
            }
        }
        return movements;
    }

    private void moveToBarycenter(List<List<CellWrapper<V>>> levels, Set<V> vertexSet) {
        for (V v : vertexSet) {
            CellWrapper<V> currentwrapper = this.vertToWrapper.get(v);
            Collection<E> edgeList = this.getNeighborEdges(v);
            for (E edge : edgeList) {
                Object neighborVertex = null;
                if (v == this.graph.getSource(edge)) {
                    neighborVertex = this.graph.getDest(edge);
                } else if (v == this.graph.getDest(edge)) {
                    neighborVertex = this.graph.getSource(edge);
                }
                if (neighborVertex == null || neighborVertex == v) continue;
                CellWrapper<V> neighborWrapper = this.vertToWrapper.get(neighborVertex);
                if (currentwrapper == null || neighborWrapper == null || ((CellWrapper)currentwrapper).level == ((CellWrapper)neighborWrapper).level) continue;
                ((CellWrapper)currentwrapper).priority++;
            }
        }
        for (List list : levels) {
            int pos = 0;
            for (CellWrapper wrapper : list) {
                wrapper.setGridPosition(pos++);
            }
        }
        int movementsCurrentLoop = -1;
        while (movementsCurrentLoop != 0) {
            int n;
            movementsCurrentLoop = 0;
            boolean bl = true;
            while (n < levels.size()) {
                movementsCurrentLoop += this.moveToBarycenter(levels, n);
                ++n;
            }
            for (n = levels.size() - 1; n >= 0; --n) {
                movementsCurrentLoop += this.moveToBarycenter(levels, n);
            }
        }
    }

    private Collection<E> getNeighborEdges(V v) {
        Collection outEdges = this.graph.getOutEdges(v);
        Collection inEdges = this.graph.getInEdges(v);
        LinkedList edgeList = new LinkedList();
        edgeList.addAll(outEdges);
        edgeList.addAll(inEdges);
        return edgeList;
    }

    private int moveToBarycenter(List<List<CellWrapper<V>>> levels, int levelIndex) {
        int movements = 0;
        List<CellWrapper<V>> currentLevel = levels.get(levelIndex);
        for (int currentIndexInTheLevel = 0; currentIndexInTheLevel < currentLevel.size(); ++currentIndexInTheLevel) {
            CellWrapper<V> sourceWrapper = currentLevel.get(currentIndexInTheLevel);
            float gridPositionsSum = 0.0f;
            float countNodes = 0.0f;
            V vertexView = sourceWrapper.getVertexView();
            Collection<E> edgeList = this.getNeighborEdges(vertexView);
            for (E edge : edgeList) {
                CellWrapper<V> targetWrapper;
                Object neighborVertex = null;
                if (vertexView == this.graph.getSource(edge)) {
                    neighborVertex = this.graph.getDest(edge);
                } else if (vertexView == this.graph.getSource(edge)) {
                    neighborVertex = this.graph.getDest(edge);
                }
                if (neighborVertex == null || (targetWrapper = this.vertToWrapper.get(neighborVertex)) == sourceWrapper && targetWrapper.getLevel() != levelIndex) continue;
                gridPositionsSum += (float)targetWrapper.getGridPosition();
                countNodes += 1.0f;
            }
            if (!(countNodes > 0.0f)) continue;
            float tmp = gridPositionsSum / countNodes;
            int newGridPosition = Math.round(tmp);
            boolean toRight = newGridPosition > sourceWrapper.getGridPosition();
            boolean moved = true;
            while (newGridPosition != sourceWrapper.getGridPosition() && moved) {
                moved = this.move(toRight, currentLevel, currentIndexInTheLevel, sourceWrapper.getPriority());
                if (!moved) continue;
                ++movements;
            }
        }
        return movements;
    }

    private boolean move(boolean toRight, List<CellWrapper<V>> currentLevel, int currentIndexInTheLevel, int currentPriority) {
        CellWrapper<V> currentWrapper = currentLevel.get(currentIndexInTheLevel);
        boolean moved = false;
        int neighborIndexInTheLevel = currentIndexInTheLevel + (toRight ? 1 : -1);
        int newGridPosition = currentWrapper.getGridPosition() + (toRight ? 1 : -1);
        if (0 > newGridPosition || newGridPosition >= this.gridAreaSize) {
            return false;
        }
        if (toRight && currentIndexInTheLevel == currentLevel.size() - 1 || !toRight && currentIndexInTheLevel == 0) {
            moved = true;
        } else {
            CellWrapper<V> neighborWrapper = currentLevel.get(neighborIndexInTheLevel);
            int neighborPriority = neighborWrapper.getPriority();
            if (neighborWrapper.getGridPosition() == newGridPosition) {
                if (neighborPriority >= currentPriority) {
                    return false;
                }
                moved = this.move(toRight, currentLevel, neighborIndexInTheLevel, currentPriority);
            } else {
                moved = true;
            }
        }
        if (moved) {
            currentWrapper.setGridPosition(newGridPosition);
        }
        return moved;
    }

    public void reset() {
        this.vertToWrapper.clear();
        this.executed = false;
    }

    private class AcyclicCalculator {
        private Set<V> onStack = new HashSet();
        private Set<V> visited = new HashSet();

        private void dfs(V vertex) {
            if (this.visited.contains(vertex)) {
                return;
            }
            this.visited.add(vertex);
            this.onStack.add(vertex);
            for (Object edge : JungSugiyama.this.graph.getOutEdges(vertex)) {
                Object target = JungSugiyama.this.graph.getDest(edge);
                if (this.onStack.contains(target)) {
                    JungSugiyama.this.graph.removeEdge(edge);
                    JungSugiyama.this.graph.addEdge(edge, target, vertex);
                    continue;
                }
                this.dfs(target);
            }
            this.onStack.remove(vertex);
        }

        public void run() {
            for (Object vertex : JungSugiyama.this.graph.getVertices()) {
                this.dfs(vertex);
            }
        }
    }

    class CellWrapper<VV>
    implements Comparable<CellWrapper<VV>> {
        private double edgeCrossesIndicator = 0.0;
        private int additions = 0;
        private int level = 0;
        private int gridPosition = 0;
        private int priority = 0;
        private VV wrappedVertex = null;
        private String vertex_name = "";

        CellWrapper(int level, double edgeCrossesIndicator, VV vertex) {
            this.level = level;
            this.edgeCrossesIndicator = edgeCrossesIndicator;
            this.wrappedVertex = vertex;
            this.vertex_name = vertex.toString();
            ++this.additions;
        }

        public String toString() {
            return this.vertex_name + "," + this.level + "," + this.gridPosition + "," + this.priority + "," + this.edgeCrossesIndicator + "," + this.additions;
        }

        VV getVertexView() {
            return this.wrappedVertex;
        }

        double getEdgeCrossesIndicator() {
            if (this.additions == 0) {
                return 0.0;
            }
            return this.edgeCrossesIndicator / (double)this.additions;
        }

        void addToEdgeCrossesIndicator(double addValue) {
            this.edgeCrossesIndicator += addValue;
            ++this.additions;
        }

        int getLevel() {
            return this.level;
        }

        int getGridPosition() {
            return this.gridPosition;
        }

        void setGridPosition(int pos) {
            this.gridPosition = pos;
        }

        int getPriority() {
            return this.priority;
        }

        @Override
        public int compareTo(CellWrapper<VV> compare) {
            if (compare.getEdgeCrossesIndicator() == this.getEdgeCrossesIndicator()) {
                return 0;
            }
            double compareValue = compare.getEdgeCrossesIndicator() - this.getEdgeCrossesIndicator();
            return (int)(compareValue * 1000.0);
        }
    }

    public static enum Orientation {
        TOP,
        LEFT;

    }
}

