/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.depgraph_view.model.graph;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import hudson.plugins.depgraph_view.model.graph.DependencyGraph;
import hudson.plugins.depgraph_view.model.graph.ProjectNode;
import hudson.plugins.depgraph_view.model.graph.SubProjectProvider;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;

public class SubprojectCalculator {
    private Set<SubProjectProvider> providers;

    @Inject
    public SubprojectCalculator(Set<SubProjectProvider> providers) {
        this.providers = providers;
    }

    public ListMultimap<ProjectNode, ProjectNode> generate(DependencyGraph graph) {
        ArrayListMultimap project2Subprojects = ArrayListMultimap.create();
        Collection<ProjectNode> nodes = graph.getNodes();
        for (ProjectNode node : nodes) {
            for (SubProjectProvider provider : this.providers) {
                project2Subprojects.putAll((Object)node, provider.getSubProjectsOf(node.getProject()));
            }
        }
        return project2Subprojects;
    }
}

