/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.depgraph_view.model.display;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import hudson.plugins.depgraph_view.model.display.AbstractDotStringGenerator;
import hudson.plugins.depgraph_view.model.graph.DependencyGraph;
import hudson.plugins.depgraph_view.model.graph.Edge;
import hudson.plugins.depgraph_view.model.graph.ProjectNode;
import java.util.List;

public class DotStringGenerator
extends AbstractDotStringGenerator {
    private static final Function<String, String> ESCAPE = new Function<String, String>(){

        public String apply(String from) {
            return AbstractDotStringGenerator.escapeString(from);
        }
    };

    public DotStringGenerator(DependencyGraph graph, ListMultimap<ProjectNode, ProjectNode> projects2Subprojects) {
        super(graph, projects2Subprojects);
    }

    @Override
    public String generate() {
        StringBuilder builder = new StringBuilder();
        builder.append("digraph {\n");
        builder.append("node [shape=box, style=rounded];\n");
        builder.append(this.cluster("Main", this.projectsInDependenciesNodes(), "color=invis;"));
        List standaloneNames = Lists.transform((List)this.standaloneProjects, (Function)Functions.compose(ESCAPE, (Function)PROJECT_NAME_FUNCTION));
        builder.append(this.cluster("Standalone", this.standaloneProjectNodes(standaloneNames), "color=invis;"));
        for (Edge edge : this.edges) {
            builder.append(this.dependencyToEdgeString(edge, new String[0]));
            builder.append(";\n");
        }
        if (!standaloneNames.isEmpty()) {
            builder.append("edge[style=\"invisible\",dir=\"none\"];\n" + Joiner.on((String)" -> ").join((Iterable)standaloneNames) + ";\n");
            builder.append("edge[style=\"invisible\",dir=\"none\"];\n" + (String)standaloneNames.get(standaloneNames.size() - 1) + " -> \"Dependency Graph\"");
        }
        builder.append("}");
        return builder.toString();
    }

    private String standaloneProjectNodes(List<String> standaloneNames) {
        StringBuilder builder = new StringBuilder();
        for (ProjectNode proj : this.standaloneProjects) {
            builder.append(this.projectToNodeString(proj, this.subJobs.get((Object)proj)));
            builder.append(";\n");
        }
        if (!standaloneNames.isEmpty()) {
            builder.append("edge[style=\"invisible\",dir=\"none\"];\n" + Joiner.on((String)" -> ").join(standaloneNames) + ";\n");
        }
        return builder.toString();
    }

    private String projectsInDependenciesNodes() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ProjectNode proj : this.projectsInDeps) {
            if (this.subJobs.containsKey((Object)proj)) {
                stringBuilder.append(this.projectToNodeString(proj, this.subJobs.get((Object)proj)));
            } else {
                stringBuilder.append(this.projectToNodeString(proj));
            }
            stringBuilder.append(";\n");
        }
        return stringBuilder.toString();
    }

    private String projectToNodeString(ProjectNode proj) {
        return DotStringGenerator.escapeString(proj.getName()) + " [href=" + this.getEscapedProjectUrl(proj) + "]";
    }

    private String projectToNodeString(ProjectNode proj, List<ProjectNode> subprojects) {
        StringBuilder builder = new StringBuilder();
        builder.append(DotStringGenerator.escapeString(proj.getName())).append(" [shape=\"Mrecord\" href=").append(this.getEscapedProjectUrl(proj)).append(" label=<<table border=\"0\" cellborder=\"0\" cellpadding=\"3\" bgcolor=\"white\">\n");
        builder.append(this.getProjectRow(proj, new String[0]));
        for (ProjectNode subproject : subprojects) {
            builder.append(this.getProjectRow(subproject, "bgcolor=" + DotStringGenerator.escapeString(this.subProjectColor))).append("\n");
        }
        builder.append("</table>>]");
        return builder.toString();
    }

    private String getProjectRow(ProjectNode project, String ... extraColumnProperties) {
        return String.format("<tr><td align=\"center\" href=%s %s>%s</td></tr>", this.getEscapedProjectUrl(project), Joiner.on((String)" ").join((Object[])extraColumnProperties), project.getName());
    }

    private String getEscapedProjectUrl(ProjectNode proj) {
        return DotStringGenerator.escapeString(proj.getProject().getAbsoluteUrl());
    }

    private String dependencyToEdgeString(Edge edge, String ... options) {
        return DotStringGenerator.escapeString(edge.source.getName()) + " -> " + DotStringGenerator.escapeString(edge.target.getName()) + " [ color=" + edge.getColor() + " " + Joiner.on((String)" ").join((Object[])options) + " ] ";
    }
}

