/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.depgraph_view;

import com.google.common.collect.ListMultimap;
import com.google.inject.Injector;
import hudson.Launcher;
import hudson.model.AbstractModelObject;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.depgraph_view.DependencyGraphProperty;
import hudson.plugins.depgraph_view.Messages;
import hudson.plugins.depgraph_view.SupportedImageType;
import hudson.plugins.depgraph_view.model.display.AbstractGraphStringGenerator;
import hudson.plugins.depgraph_view.model.display.DotGeneratorFactory;
import hudson.plugins.depgraph_view.model.display.GeneratorFactory;
import hudson.plugins.depgraph_view.model.display.JsonGeneratorFactory;
import hudson.plugins.depgraph_view.model.graph.DependencyGraph;
import hudson.plugins.depgraph_view.model.graph.GraphCalculator;
import hudson.plugins.depgraph_view.model.graph.ProjectNode;
import hudson.plugins.depgraph_view.model.graph.SubprojectCalculator;
import hudson.plugins.depgraph_view.model.operations.DeleteEdgeOperation;
import hudson.plugins.depgraph_view.model.operations.PutEdgeOperation;
import hudson.util.LogTaskListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.ModelObjectWithContextMenu;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class AbstractDependencyGraphAction
implements Action {
    private final Logger LOGGER = Logger.getLogger(Logger.class.getName());
    private static final Pattern EDGE_PATTERN = Pattern.compile("/(.*)/(.*[^/])(.*)");

    public ModelObjectWithContextMenu.ContextMenu doContextMenu(StaplerRequest request, StaplerResponse response) throws Exception {
        return new ModelObjectWithContextMenu.ContextMenu();
    }

    public void doEdge(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
        String path = req.getRestOfPath();
        Matcher m = EDGE_PATTERN.matcher(path);
        if (m.find()) {
            try {
                String sourceJobName = m.group(1);
                String targetJobName = m.group(2);
                if ("PUT".equalsIgnoreCase(req.getMethod())) {
                    new PutEdgeOperation(sourceJobName, targetJobName).perform();
                } else if ("DELETE".equalsIgnoreCase(req.getMethod())) {
                    new DeleteEdgeOperation(sourceJobName, targetJobName).perform();
                }
            }
            catch (Exception e) {
                rsp.sendError(500);
            }
        } else {
            rsp.sendError(404);
        }
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
        String path = req.getRestOfPath();
        SupportedImageType imageType = null;
        try {
            imageType = SupportedImageType.valueOf(path.substring(path.lastIndexOf(46) + 1).toUpperCase());
        }
        catch (Exception e) {
            imageType = SupportedImageType.PNG;
        }
        GeneratorFactory generatorFactory = imageType == SupportedImageType.JSON ? new JsonGeneratorFactory() : new DotGeneratorFactory();
        AbstractGraphStringGenerator stringGenerator = null;
        if (path.startsWith("/graph.")) {
            Injector injector = (Injector)Jenkins.lookup(Injector.class);
            GraphCalculator graphCalculator = (GraphCalculator)injector.getInstance(GraphCalculator.class);
            DependencyGraph graph = graphCalculator.generateGraph(GraphCalculator.abstractProjectSetToProjectNodeSet(this.getProjectsForDepgraph()));
            ListMultimap<ProjectNode, ProjectNode> projects2Subprojects = ((SubprojectCalculator)injector.getInstance(SubprojectCalculator.class)).generate(graph);
            stringGenerator = generatorFactory.newGenerator(graph, projects2Subprojects);
        } else if (path.startsWith("/legend.")) {
            stringGenerator = generatorFactory.newLegendGenerator();
        } else {
            rsp.sendError(501);
            return;
        }
        String graphString = stringGenerator.generate();
        rsp.setContentType(imageType.contentType);
        if (imageType.requiresProcessing) {
            this.runDot((OutputStream)rsp.getOutputStream(), new ByteArrayInputStream(graphString.getBytes(Charset.forName("UTF-8"))), imageType.dotType);
        } else {
            rsp.getWriter().append(graphString).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runDot(OutputStream output, InputStream input, String type) throws IOException {
        DependencyGraphProperty.DescriptorImpl descriptor = (DependencyGraphProperty.DescriptorImpl)Hudson.getInstance().getDescriptorByType(DependencyGraphProperty.DescriptorImpl.class);
        String dotPath = descriptor.getDotExeOrDefault();
        Launcher launcher = Hudson.getInstance().createLauncher((TaskListener)new LogTaskListener(this.LOGGER, Level.CONFIG));
        try {
            launcher.launch().cmds(new String[]{dotPath, "-T" + type, "-Gcharset=UTF-8", "-q1"}).stdin(input).stdout(output).start().join();
        }
        catch (InterruptedException e) {
            this.LOGGER.log(Level.SEVERE, "Interrupted while waiting for dot-file to be created", e);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public boolean isGraphvizEnabled() {
        return ((DependencyGraphProperty.DescriptorImpl)Hudson.getInstance().getDescriptorByType(DependencyGraphProperty.DescriptorImpl.class)).isGraphvizEnabled();
    }

    public boolean isEditFunctionInJSViewEnabled() {
        return ((DependencyGraphProperty.DescriptorImpl)Hudson.getInstance().getDescriptorByType(DependencyGraphProperty.DescriptorImpl.class)).isEditFunctionInJSViewEnabled();
    }

    protected abstract Collection<? extends AbstractProject<?, ?>> getProjectsForDepgraph();

    public abstract String getTitle();

    public abstract AbstractModelObject getParentObject();

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getDisplayName() {
        return Messages.AbstractDependencyGraphAction_DependencyGraph();
    }

    public String getUrlName() {
        return "depgraph-view";
    }
}

