/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.depgraph_view.model.graph;

import com.google.common.collect.Sets;
import edu.uci.ics.jung.algorithms.filters.VertexPredicateFilter;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import hudson.plugins.depgraph_view.model.graph.Edge;
import hudson.plugins.depgraph_view.model.graph.ProjectNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections15.Predicate;

public class DependencyGraph {
    private DirectedSparseMultigraph<ProjectNode, Edge> graph = new DirectedSparseMultigraph();

    public void addEdge(Edge edge) {
        this.graph.addEdge((Object)edge, edge.getNodes());
    }

    public <T extends Edge> Set<ProjectNode> addEdgesWithNodes(Iterable<T> edges) {
        HashSet newNodes = Sets.newHashSet();
        for (Edge edge : edges) {
            for (ProjectNode node : edge.getNodes()) {
                if (this.graph.containsVertex((Object)node)) continue;
                this.graph.addVertex((Object)node);
                newNodes.add(node);
            }
            this.addEdge(edge);
        }
        return newNodes;
    }

    public <T extends ProjectNode> void addNodes(Iterable<T> nodes) {
        for (ProjectNode node : nodes) {
            this.graph.addVertex((Object)node);
        }
    }

    public Collection<Edge> getEdges() {
        return this.graph.getEdges();
    }

    public Collection<Edge> findEdgeSet(ProjectNode from, ProjectNode to) {
        return this.graph.findEdgeSet((Object)from, (Object)to);
    }

    public Collection<ProjectNode> getNodes() {
        return this.graph.getVertices();
    }

    public Collection<ProjectNode> getIsolatedNodes() {
        return new VertexPredicateFilter((Predicate)new Predicate<ProjectNode>(){

            public boolean evaluate(ProjectNode projectNode) {
                return DependencyGraph.this.graph.degree((Object)projectNode) == 0;
            }
        }).transform(this.graph).getVertices();
    }

    public Graph<ProjectNode, Edge> getGraph() {
        return this.graph;
    }
}

