/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.depgraph_view.model.graph;

import com.google.common.collect.Sets;
import hudson.model.AbstractProject;
import hudson.model.FreeStyleProject;
import hudson.plugins.copyartifact.CopyArtifact;
import hudson.plugins.depgraph_view.model.graph.CopyArtifactEdge;
import hudson.plugins.depgraph_view.model.graph.Edge;
import hudson.plugins.depgraph_view.model.graph.EdgeProvider;
import hudson.plugins.depgraph_view.model.graph.ProjectNode;
import hudson.tasks.Builder;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import jenkins.model.Jenkins;

public class CopyArtifactEdgeProvider
implements EdgeProvider {
    private boolean copyartifactIsInstalled;

    @Inject
    public CopyArtifactEdgeProvider(Jenkins jenkins) {
        this.copyartifactIsInstalled = jenkins.getPlugin("copyartifact") != null;
    }

    @Override
    public Iterable<Edge> getEdgesIncidentWith(AbstractProject<?, ?> project) {
        HashSet artifactEdges = Sets.newHashSet();
        if (this.copyartifactIsInstalled && project instanceof FreeStyleProject) {
            FreeStyleProject proj = (FreeStyleProject)project;
            List builders = proj.getBuilders();
            for (Builder builder : builders) {
                if (!(builder instanceof CopyArtifact)) continue;
                CopyArtifact caBuilder = (CopyArtifact)builder;
                String projectName = caBuilder.getProjectName();
                Jenkins jenkins = Jenkins.getInstance();
                AbstractProject projectFromName = (AbstractProject)jenkins.getItem(projectName, project.getParent(), AbstractProject.class);
                if (projectFromName == null) continue;
                artifactEdges.add(new CopyArtifactEdge(ProjectNode.node(projectFromName), ProjectNode.node(project)));
            }
        }
        return artifactEdges;
    }
}

