/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.depgraph_view;

import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.plugins.depgraph_view.Messages;
import hudson.util.FormValidation;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class DependencyGraphProperty
extends AbstractDescribableImpl<DependencyGraphProperty> {
    @DataBoundConstructor
    public DependencyGraphProperty() {
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DependencyGraphProperty> {
        private String dotExe;
        private boolean graphvizEnabled = true;
        private boolean editFunctionInJSViewEnabled = false;

        public DescriptorImpl() {
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject o) {
            JSONObject go = o.optJSONObject("graphviz");
            if (go != null) {
                this.dotExe = Util.fixEmptyAndTrim((String)go.optString("dotExe"));
                this.graphvizEnabled = true;
            } else {
                this.dotExe = null;
                this.graphvizEnabled = false;
            }
            this.editFunctionInJSViewEnabled = o.optBoolean("editFunctionInJSViewEnabled");
            this.save();
            return true;
        }

        public String getDisplayName() {
            return Messages.DependencyGraphProperty_DependencyGraphViewer();
        }

        public String getDotExe() {
            return this.dotExe;
        }

        public boolean isGraphvizEnabled() {
            return this.graphvizEnabled;
        }

        public boolean isEditFunctionInJSViewEnabled() {
            return this.editFunctionInJSViewEnabled;
        }

        public String getDotExeOrDefault() {
            if (Util.fixEmptyAndTrim((String)this.dotExe) == null) {
                return Functions.isWindows() ? "dot.exe" : "dot";
            }
            return this.dotExe;
        }

        public synchronized void setDotExe(String dotPath) {
            this.dotExe = dotPath;
            this.save();
        }

        public synchronized void setGraphvizEnabled(boolean graphvizEnabled) {
            this.graphvizEnabled = graphvizEnabled;
            this.save();
        }

        public void setEditFunctionInJSViewEnabled(boolean editFunctionInJSViewEnabled) {
            this.editFunctionInJSViewEnabled = editFunctionInJSViewEnabled;
            this.save();
        }

        public FormValidation doCheckDotExe(@QueryParameter String value) {
            return FormValidation.validateExecutable((String)value);
        }
    }
}

