/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyTrack.model;

import hudson.model.Result;
import java.io.Serializable;
import lombok.Generated;
import lombok.NonNull;
import org.jenkinsci.plugins.DependencyTrack.model.SeverityDistribution;
import org.jenkinsci.plugins.DependencyTrack.model.Thresholds;

public class RiskGate
implements Serializable {
    private static final long serialVersionUID = 171256230735670985L;
    @NonNull
    private final Thresholds thresholds;

    public Result evaluate(@NonNull SeverityDistribution currentDistribution, @NonNull SeverityDistribution previousDistribution) {
        if (currentDistribution == null) {
            throw new NullPointerException("currentDistribution is marked non-null but is null");
        }
        if (previousDistribution == null) {
            throw new NullPointerException("previousDistribution is marked non-null but is null");
        }
        Result result = Result.SUCCESS;
        if (this.thresholds.totalFindings.failedCritical != null && currentDistribution.getCritical() > 0 && currentDistribution.getCritical() >= this.thresholds.totalFindings.failedCritical || this.thresholds.totalFindings.failedHigh != null && currentDistribution.getHigh() > 0 && currentDistribution.getHigh() >= this.thresholds.totalFindings.failedHigh || this.thresholds.totalFindings.failedMedium != null && currentDistribution.getMedium() > 0 && currentDistribution.getMedium() >= this.thresholds.totalFindings.failedMedium || this.thresholds.totalFindings.failedLow != null && currentDistribution.getLow() > 0 && currentDistribution.getLow() >= this.thresholds.totalFindings.failedLow) {
            return Result.FAILURE;
        }
        if (this.thresholds.totalFindings.unstableCritical != null && currentDistribution.getCritical() > 0 && currentDistribution.getCritical() >= this.thresholds.totalFindings.unstableCritical || this.thresholds.totalFindings.unstableHigh != null && currentDistribution.getHigh() > 0 && currentDistribution.getHigh() >= this.thresholds.totalFindings.unstableHigh || this.thresholds.totalFindings.unstableMedium != null && currentDistribution.getMedium() > 0 && currentDistribution.getMedium() >= this.thresholds.totalFindings.unstableMedium || this.thresholds.totalFindings.unstableLow != null && currentDistribution.getLow() > 0 && currentDistribution.getLow() >= this.thresholds.totalFindings.unstableLow) {
            result = Result.UNSTABLE;
        }
        if (this.thresholds.newFindings.failedCritical != null && currentDistribution.getCritical() > 0 && currentDistribution.getCritical() >= previousDistribution.getCritical() + this.thresholds.newFindings.failedCritical || this.thresholds.newFindings.failedHigh != null && currentDistribution.getHigh() > 0 && currentDistribution.getHigh() >= previousDistribution.getHigh() + this.thresholds.newFindings.failedHigh || this.thresholds.newFindings.failedMedium != null && currentDistribution.getMedium() > 0 && currentDistribution.getMedium() >= previousDistribution.getMedium() + this.thresholds.newFindings.failedMedium || this.thresholds.newFindings.failedLow != null && currentDistribution.getLow() > 0 && currentDistribution.getLow() >= previousDistribution.getLow() + this.thresholds.newFindings.failedLow) {
            return Result.FAILURE;
        }
        if (this.thresholds.newFindings.unstableCritical != null && currentDistribution.getCritical() > 0 && currentDistribution.getCritical() >= previousDistribution.getCritical() + this.thresholds.newFindings.unstableCritical || this.thresholds.newFindings.unstableHigh != null && currentDistribution.getHigh() > 0 && currentDistribution.getHigh() >= previousDistribution.getHigh() + this.thresholds.newFindings.unstableHigh || this.thresholds.newFindings.unstableMedium != null && currentDistribution.getMedium() > 0 && currentDistribution.getMedium() >= previousDistribution.getMedium() + this.thresholds.newFindings.unstableMedium || this.thresholds.newFindings.unstableLow != null && currentDistribution.getLow() > 0 && currentDistribution.getLow() >= previousDistribution.getLow() + this.thresholds.newFindings.unstableLow) {
            result = Result.UNSTABLE;
        }
        return result;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RiskGate)) {
            return false;
        }
        RiskGate other = (RiskGate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Thresholds this$thresholds = this.thresholds;
        Thresholds other$thresholds = other.thresholds;
        return !(this$thresholds == null ? other$thresholds != null : !((Object)this$thresholds).equals(other$thresholds));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RiskGate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Thresholds $thresholds = this.thresholds;
        result = result * 59 + ($thresholds == null ? 43 : ((Object)$thresholds).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RiskGate(thresholds=" + this.thresholds + ")";
    }

    @Generated
    public RiskGate(@NonNull Thresholds thresholds) {
        if (thresholds == null) {
            throw new NullPointerException("thresholds is marked non-null but is null");
        }
        this.thresholds = thresholds;
    }
}

