/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyTrack;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Plugin;
import hudson.PluginWrapper;
import hudson.model.Action;
import hudson.model.Run;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import jenkins.model.Jenkins;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import lombok.Generated;
import net.sf.json.JSONArray;
import org.apache.commons.codec.digest.DigestUtils;
import org.jenkinsci.plugins.DependencyTrack.JobAction;
import org.jenkinsci.plugins.DependencyTrack.Messages;
import org.jenkinsci.plugins.DependencyTrack.model.Finding;
import org.jenkinsci.plugins.DependencyTrack.model.SeverityDistribution;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class ResultAction
implements RunAction2,
SimpleBuildStep.LastBuildAction,
Serializable {
    private static final long serialVersionUID = 9144544646132489130L;
    private transient Run<?, ?> run;
    private final List<Finding> findings;
    private final SeverityDistribution severityDistribution;
    private String dependencyTrackUrl;
    private String projectId;

    public String getIconFileName() {
        return "/plugin/dependency-track/icons/dt-logo-symbol.svg";
    }

    public String getDisplayName() {
        return Messages.Result_DT_Report();
    }

    public String getUrlName() {
        return "dependency-track-findings";
    }

    public void onAttached(Run<?, ?> run) {
        this.run = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.run = run;
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new JobAction(this.run.getParent()));
    }

    @NonNull
    public String getVersionHash() {
        return DigestUtils.sha256Hex((String)Optional.ofNullable(Jenkins.get().getPlugin("dependency-track")).map(Plugin::getWrapper).map(PluginWrapper::getVersion).orElse(""));
    }

    @JavaScriptMethod
    public JSONArray getFindingsJson() {
        return JSONArray.fromObject(this.findings);
    }

    @Generated
    public Run<?, ?> getRun() {
        return this.run;
    }

    @Generated
    public List<Finding> getFindings() {
        return this.findings;
    }

    @Generated
    public SeverityDistribution getSeverityDistribution() {
        return this.severityDistribution;
    }

    @Generated
    public String getDependencyTrackUrl() {
        return this.dependencyTrackUrl;
    }

    @Generated
    public String getProjectId() {
        return this.projectId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultAction)) {
            return false;
        }
        ResultAction other = (ResultAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Finding> this$findings = this.getFindings();
        List<Finding> other$findings = other.getFindings();
        if (this$findings == null ? other$findings != null : !((Object)this$findings).equals(other$findings)) {
            return false;
        }
        SeverityDistribution this$severityDistribution = this.getSeverityDistribution();
        SeverityDistribution other$severityDistribution = other.getSeverityDistribution();
        if (this$severityDistribution == null ? other$severityDistribution != null : !((Object)this$severityDistribution).equals(other$severityDistribution)) {
            return false;
        }
        String this$dependencyTrackUrl = this.getDependencyTrackUrl();
        String other$dependencyTrackUrl = other.getDependencyTrackUrl();
        if (this$dependencyTrackUrl == null ? other$dependencyTrackUrl != null : !this$dependencyTrackUrl.equals(other$dependencyTrackUrl)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        return !(this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResultAction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Finding> $findings = this.getFindings();
        result = result * 59 + ($findings == null ? 43 : ((Object)$findings).hashCode());
        SeverityDistribution $severityDistribution = this.getSeverityDistribution();
        result = result * 59 + ($severityDistribution == null ? 43 : ((Object)$severityDistribution).hashCode());
        String $dependencyTrackUrl = this.getDependencyTrackUrl();
        result = result * 59 + ($dependencyTrackUrl == null ? 43 : $dependencyTrackUrl.hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        return result;
    }

    @Generated
    public ResultAction(List<Finding> findings, SeverityDistribution severityDistribution) {
        this.findings = findings;
        this.severityDistribution = severityDistribution;
    }

    @Generated
    public void setDependencyTrackUrl(String dependencyTrackUrl) {
        this.dependencyTrackUrl = dependencyTrackUrl;
    }

    @Generated
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }
}

