/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyTrack;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.DependencyTrack.model.Project;

final class ProjectParser {
    static Project parse(JSONObject json) {
        String lastInheritedRiskScoreStr = ProjectParser.getKeyOrNull(json, "lastInheritedRiskScore");
        String activeStr = ProjectParser.getKeyOrNull(json, "active");
        return Project.builder().name(ProjectParser.getKeyOrNull(json, "name")).description(ProjectParser.getKeyOrNull(json, "description")).version(ProjectParser.getKeyOrNull(json, "version")).uuid(ProjectParser.getKeyOrNull(json, "uuid")).tags(json.has("tags") ? ProjectParser.parseTags(json.getJSONArray("tags")) : Collections.emptyList()).lastBomImport(ProjectParser.parseDateTime(ProjectParser.getKeyOrNull(json, "lastBomImportStr"))).lastBomImportFormat(ProjectParser.getKeyOrNull(json, "lastBomImportFormat")).lastInheritedRiskScore(lastInheritedRiskScoreStr != null ? Double.valueOf(Double.parseDouble(lastInheritedRiskScoreStr)) : null).active(activeStr != null ? Boolean.valueOf(Boolean.parseBoolean(activeStr)) : null).build();
    }

    private static String getKeyOrNull(JSONObject json, String key) {
        Object v = json.opt(key);
        if (v instanceof JSONNull) {
            v = null;
        }
        return v == null ? null : StringUtils.trimToNull((String)v.toString());
    }

    private static LocalDateTime parseDateTime(String dateTime) {
        if (dateTime == null) {
            return null;
        }
        return LocalDateTime.parse(dateTime);
    }

    private static List<String> parseTags(JSONArray tagArray) {
        return tagArray.stream().map(o -> ProjectParser.getKeyOrNull((JSONObject)o, "name")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    @Generated
    private ProjectParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

