/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyTrack;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.util.FormValidation;
import java.net.MalformedURLException;
import java.net.URL;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;

final class PluginUtil {
    static FormValidation doCheckUrl(String value) {
        if (StringUtils.isBlank((String)value)) {
            return FormValidation.ok();
        }
        try {
            URL url = new URL(value);
            if (!url.getProtocol().toLowerCase().matches("https?")) {
                return FormValidation.error((String)"Only URLs with http and https are supported");
            }
        }
        catch (MalformedURLException e) {
            return FormValidation.error((String)"The specified value is not a valid URL");
        }
        return FormValidation.ok();
    }

    @Nullable
    static String parseBaseUrl(String baseUrl) {
        return StringUtils.removeEnd((String)StringUtils.trimToNull((String)baseUrl), (String)"/");
    }

    @Generated
    private PluginUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

