/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyTrack;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.DependencyTrack.model.Analysis;
import org.jenkinsci.plugins.DependencyTrack.model.Component;
import org.jenkinsci.plugins.DependencyTrack.model.Finding;
import org.jenkinsci.plugins.DependencyTrack.model.Severity;
import org.jenkinsci.plugins.DependencyTrack.model.Vulnerability;

final class FindingParser {
    static List<Finding> parse(String jsonResponse) {
        JSONArray jsonArray = JSONArray.fromObject((Object)jsonResponse);
        return jsonArray.stream().map(o -> FindingParser.parseFinding((JSONObject)o)).collect(Collectors.toList());
    }

    private static Finding parseFinding(JSONObject json) {
        Component component = FindingParser.parseComponent(json.getJSONObject("component"));
        Vulnerability vulnerability = FindingParser.parseVulnerability(json.getJSONObject("vulnerability"));
        Analysis analysis = FindingParser.parseAnalysis(json.optJSONObject("analysis"));
        String matrix = FindingParser.getKeyOrNull(json, "matrix");
        return new Finding(component, vulnerability, analysis, matrix);
    }

    private static Component parseComponent(JSONObject json) {
        String uuid = FindingParser.getKeyOrNull(json, "uuid");
        String name = FindingParser.getKeyOrNull(json, "name");
        String group = FindingParser.getKeyOrNull(json, "group");
        String version = FindingParser.getKeyOrNull(json, "version");
        String purl = FindingParser.getKeyOrNull(json, "purl");
        return new Component(uuid, name, group, version, purl);
    }

    private static Vulnerability parseVulnerability(JSONObject json) {
        String uuid = FindingParser.getKeyOrNull(json, "uuid");
        String source = FindingParser.getKeyOrNull(json, "source");
        String vulnId = FindingParser.getKeyOrNull(json, "vulnId");
        String title = FindingParser.getKeyOrNull(json, "title");
        String subtitle = FindingParser.getKeyOrNull(json, "subtitle");
        String description = FindingParser.getKeyOrNull(json, "description");
        String recommendation = FindingParser.getKeyOrNull(json, "recommendation");
        Severity severity = Severity.valueOf(json.optString("severity"));
        Integer severityRank = json.optInt("severityRank");
        Integer cweId = json.optInt("cweId");
        String cweName = FindingParser.getKeyOrNull(json, "cweName");
        return new Vulnerability(uuid, source, vulnId, title, subtitle, description, recommendation, severity, severityRank, cweId, cweName);
    }

    private static Analysis parseAnalysis(JSONObject json) {
        String state = FindingParser.getKeyOrNull(json, "state");
        boolean isSuppressed = json.optBoolean("isSuppressed", false);
        return new Analysis(state, isSuppressed);
    }

    private static String getKeyOrNull(JSONObject json, String key) {
        Object v = json.opt(key);
        if (v instanceof JSONNull) {
            v = null;
        }
        return v == null ? null : StringUtils.trimToNull((String)v.toString());
    }

    @Generated
    private FindingParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

