/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyTrack;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import lombok.Generated;
import lombok.NonNull;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.DependencyTrack.ApiClient;
import org.jenkinsci.plugins.DependencyTrack.ApiClientException;
import org.jenkinsci.plugins.DependencyTrack.ApiClientFactory;
import org.jenkinsci.plugins.DependencyTrack.ConsoleLogger;
import org.jenkinsci.plugins.DependencyTrack.DependencyTrackPublisher;
import org.jenkinsci.plugins.DependencyTrack.Messages;
import org.jenkinsci.plugins.DependencyTrack.PluginUtil;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
@Symbol(value={"dependencyTrackPublisher"})
public final class DescriptorImpl
extends BuildStepDescriptor<Publisher>
implements Serializable {
    private static final long serialVersionUID = -2018722914973282748L;
    private final transient ApiClientFactory clientFactory;
    private String dependencyTrackUrl;
    private String dependencyTrackFrontendUrl;
    private String dependencyTrackApiKey;
    private boolean dependencyTrackAutoCreateProjects;
    private int dependencyTrackPollingTimeout;
    private int dependencyTrackPollingInterval;
    private int dependencyTrackConnectionTimeout;
    private int dependencyTrackReadTimeout;

    public DescriptorImpl() {
        this(ApiClient::new);
    }

    DescriptorImpl(@NonNull ApiClientFactory clientFactory) {
        super(DependencyTrackPublisher.class);
        if (clientFactory == null) {
            throw new NullPointerException("clientFactory is marked non-null but is null");
        }
        this.clientFactory = clientFactory;
        this.load();
    }

    public boolean isApplicable(Class<? extends AbstractProject> aClass) {
        return true;
    }

    public ListBoxModel doFillProjectIdItems(@QueryParameter String dependencyTrackUrl, @QueryParameter String dependencyTrackApiKey, @AncestorInPath @Nullable Item item) {
        ListBoxModel projects = new ListBoxModel();
        try {
            String url = Optional.ofNullable(PluginUtil.parseBaseUrl(dependencyTrackUrl)).orElse(this.getDependencyTrackUrl());
            String apiKey = this.lookupApiKey(Optional.ofNullable(StringUtils.trimToNull((String)dependencyTrackApiKey)).orElse(this.getDependencyTrackApiKey()), item);
            ApiClient apiClient = this.getClient(url, apiKey);
            projects.addAll((Collection)apiClient.getProjects().stream().map(p -> new ListBoxModel.Option(p.getName().concat(" ").concat(Optional.ofNullable(p.getVersion()).orElse("")).trim(), p.getUuid())).sorted(Comparator.comparing(o -> o.name)).collect(Collectors.toList()));
            projects.add(0, (Object)new ListBoxModel.Option("-- Select Project --", null));
        }
        catch (ApiClientException e) {
            projects.add(Messages.Builder_Error_Projects(e.getLocalizedMessage()), null);
        }
        return projects;
    }

    public ListBoxModel doFillDependencyTrackApiKeyItems(@QueryParameter String credentialsId, @AncestorInPath Item item) {
        StandardListBoxModel result = new StandardListBoxModel();
        if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
            return result.includeCurrentValue(credentialsId);
        }
        return result.includeEmptyValue().includeAs(ACL.SYSTEM, item, StringCredentials.class, Collections.emptyList()).includeCurrentValue(credentialsId);
    }

    public FormValidation doCheckDependencyTrackUrl(@QueryParameter String value) {
        return PluginUtil.doCheckUrl(value);
    }

    public FormValidation doCheckDependencyTrackFrontendUrl(@QueryParameter String value) {
        return PluginUtil.doCheckUrl(value);
    }

    public FormValidation doTestConnection(@QueryParameter String dependencyTrackUrl, @QueryParameter String dependencyTrackApiKey, @AncestorInPath @Nullable Item item) {
        String url = Optional.ofNullable(PluginUtil.parseBaseUrl(dependencyTrackUrl)).orElse(this.getDependencyTrackUrl());
        String apiKey = this.lookupApiKey(Optional.ofNullable(StringUtils.trimToNull((String)dependencyTrackApiKey)).orElse(this.getDependencyTrackApiKey()), item);
        if (this.doCheckDependencyTrackUrl((String)url).kind == FormValidation.Kind.OK && StringUtils.isNotBlank((String)apiKey)) {
            try {
                ApiClient apiClient = this.getClient(url, apiKey);
                String result = apiClient.testConnection();
                return result.startsWith("Dependency-Track v") ? FormValidation.ok((String)("Connection successful - " + result)) : FormValidation.error((String)("Connection failed - " + result));
            }
            catch (ApiClientException e) {
                return FormValidation.error((Throwable)e, (String)"Connection failed");
            }
        }
        return FormValidation.warning((String)"URL must be valid and Api-Key must not be empty");
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        req.bindJSON((Object)this, formData);
        this.save();
        return super.configure(req, formData);
    }

    public String getDisplayName() {
        return Messages.Publisher_DependencyTrack_Name();
    }

    @CheckForNull
    public String getDependencyTrackUrl() {
        return PluginUtil.parseBaseUrl(this.dependencyTrackUrl);
    }

    @CheckForNull
    public String getDependencyTrackFrontendUrl() {
        return PluginUtil.parseBaseUrl(this.dependencyTrackFrontendUrl);
    }

    public int getDependencyTrackPollingTimeout() {
        if (this.dependencyTrackPollingTimeout <= 0) {
            return 5;
        }
        return this.dependencyTrackPollingTimeout;
    }

    public int getDependencyTrackPollingInterval() {
        if (this.dependencyTrackPollingInterval <= 0) {
            return 10;
        }
        return this.dependencyTrackPollingInterval;
    }

    private ApiClient getClient(String baseUrl, String apiKey) {
        return this.clientFactory.create(baseUrl, apiKey, new ConsoleLogger(), Math.max(this.dependencyTrackConnectionTimeout, 0), Math.max(this.dependencyTrackReadTimeout, 0));
    }

    private String lookupApiKey(String credentialId, Item item) {
        return CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList()).stream().filter(c -> c.getId().equals(credentialId)).map(StringCredentials::getSecret).map(Secret::getPlainText).findFirst().orElse("");
    }

    @DataBoundSetter
    @Generated
    public void setDependencyTrackUrl(String dependencyTrackUrl) {
        this.dependencyTrackUrl = dependencyTrackUrl;
    }

    @DataBoundSetter
    @Generated
    public void setDependencyTrackFrontendUrl(String dependencyTrackFrontendUrl) {
        this.dependencyTrackFrontendUrl = dependencyTrackFrontendUrl;
    }

    @CheckForNull
    @Generated
    public String getDependencyTrackApiKey() {
        return this.dependencyTrackApiKey;
    }

    @DataBoundSetter
    @Generated
    public void setDependencyTrackApiKey(String dependencyTrackApiKey) {
        this.dependencyTrackApiKey = dependencyTrackApiKey;
    }

    @Generated
    public boolean isDependencyTrackAutoCreateProjects() {
        return this.dependencyTrackAutoCreateProjects;
    }

    @DataBoundSetter
    @Generated
    public void setDependencyTrackAutoCreateProjects(boolean dependencyTrackAutoCreateProjects) {
        this.dependencyTrackAutoCreateProjects = dependencyTrackAutoCreateProjects;
    }

    @DataBoundSetter
    @Generated
    public void setDependencyTrackPollingTimeout(int dependencyTrackPollingTimeout) {
        this.dependencyTrackPollingTimeout = dependencyTrackPollingTimeout;
    }

    @DataBoundSetter
    @Generated
    public void setDependencyTrackPollingInterval(int dependencyTrackPollingInterval) {
        this.dependencyTrackPollingInterval = dependencyTrackPollingInterval;
    }

    @Generated
    public int getDependencyTrackConnectionTimeout() {
        return this.dependencyTrackConnectionTimeout;
    }

    @DataBoundSetter
    @Generated
    public void setDependencyTrackConnectionTimeout(int dependencyTrackConnectionTimeout) {
        this.dependencyTrackConnectionTimeout = dependencyTrackConnectionTimeout;
    }

    @Generated
    public int getDependencyTrackReadTimeout() {
        return this.dependencyTrackReadTimeout;
    }

    @DataBoundSetter
    @Generated
    public void setDependencyTrackReadTimeout(int dependencyTrackReadTimeout) {
        this.dependencyTrackReadTimeout = dependencyTrackReadTimeout;
    }
}

