/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyTrack;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.DependencyTrack.ApiClientException;
import org.jenkinsci.plugins.DependencyTrack.ConsoleLogger;
import org.jenkinsci.plugins.DependencyTrack.FindingParser;
import org.jenkinsci.plugins.DependencyTrack.Messages;
import org.jenkinsci.plugins.DependencyTrack.ProjectParser;
import org.jenkinsci.plugins.DependencyTrack.model.Finding;
import org.jenkinsci.plugins.DependencyTrack.model.Project;
import org.jenkinsci.plugins.DependencyTrack.model.UploadResult;

public class ApiClient {
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_ACCEPT = "Accept";
    private static final String MEDIATYPE_JSON = "application/json";
    private static final String API_URL = "/api/v1";
    private static final int MS_TO_S_FACTOR = 1000;
    static final String API_KEY_HEADER = "X-Api-Key";
    static final String PROJECT_FINDINGS_URL = "/api/v1/finding/project";
    static final String BOM_URL = "/api/v1/bom";
    static final String BOM_TOKEN_URL = "/api/v1/bom/token";
    static final String PROJECT_URL = "/api/v1/project";
    static final String PROJECT_LOOKUP_URL = "/api/v1/project/lookup";
    static final String PROJECT_LOOKUP_NAME_PARAM = "name";
    static final String PROJECT_LOOKUP_VERSION_PARAM = "version";
    private final String baseUrl;
    private final String apiKey;
    private final ConsoleLogger logger;
    private final int connectionTimeout;
    private final int readTimeout;

    @NonNull
    public String testConnection() throws ApiClientException {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(this.baseUrl + PROJECT_URL).openConnection();
            conn.setRequestProperty(HEADER_ACCEPT, MEDIATYPE_JSON);
            conn.setRequestProperty(API_KEY_HEADER, this.apiKey);
            conn.setConnectTimeout(this.connectionTimeout * 1000);
            conn.setReadTimeout(this.readTimeout * 1000);
            conn.connect();
            if (conn.getResponseCode() == 200) {
                return StringUtils.trimToEmpty((String)conn.getHeaderField("X-Powered-By"));
            }
            this.logHttpError(conn);
            throw new ApiClientException(Messages.ApiClient_Error_Connection(conn.getResponseCode(), conn.getResponseMessage()));
        }
        catch (ApiClientException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ApiClientException(Messages.ApiClient_Error_Connection("", ""), e);
        }
    }

    @NonNull
    public List<Project> getProjects() throws ApiClientException {
        ArrayList<Project> projects = new ArrayList<Project>();
        int page = 1;
        boolean fetchMore = true;
        while (fetchMore) {
            List<Project> fetchedProjects;
            fetchMore = !(fetchedProjects = this.getProjectsPaged(page++)).isEmpty();
            projects.addAll(fetchedProjects);
        }
        return projects;
    }

    @NonNull
    private List<Project> getProjectsPaged(int page) throws ApiClientException {
        block7: {
            List<Project> list;
            HttpURLConnection conn = (HttpURLConnection)new URL(this.baseUrl + PROJECT_URL + "?limit=500&excludeInactive=true&page=" + page).openConnection();
            conn.setRequestProperty(HEADER_ACCEPT, MEDIATYPE_JSON);
            conn.setRequestProperty(API_KEY_HEADER, this.apiKey);
            conn.setConnectTimeout(this.connectionTimeout * 1000);
            conn.setReadTimeout(this.readTimeout * 1000);
            conn.setDoOutput(true);
            conn.connect();
            if (conn.getResponseCode() != 200) break block7;
            BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
            try {
                JSONArray array = JSONArray.fromObject((Object)this.getResponseBody(in));
                list = array.stream().map(o -> ProjectParser.parse((JSONObject)o)).collect(Collectors.toList());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ApiClientException(Messages.ApiClient_Error_Connection("", ""), e);
                }
            }
            ((InputStream)in).close();
            return list;
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public Project lookupProject(String projectName, String projectVersion) throws ApiClientException {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(this.baseUrl + PROJECT_LOOKUP_URL + "?" + PROJECT_LOOKUP_NAME_PARAM + "=" + URLEncoder.encode(projectName, StandardCharsets.UTF_8.name()) + "&" + PROJECT_LOOKUP_VERSION_PARAM + "=" + URLEncoder.encode(projectVersion, StandardCharsets.UTF_8.name())).openConnection();
            conn.setDoOutput(true);
            conn.setRequestProperty(API_KEY_HEADER, this.apiKey);
            conn.setRequestProperty(HEADER_ACCEPT, MEDIATYPE_JSON);
            conn.setConnectTimeout(this.connectionTimeout * 1000);
            conn.setReadTimeout(this.readTimeout * 1000);
            conn.connect();
            if (conn.getResponseCode() != 200) {
                this.logHttpError(conn);
                throw new ApiClientException(Messages.ApiClient_Error_ProjectLookup(projectName, projectVersion, conn.getResponseCode(), conn.getResponseMessage()));
            }
            try (BufferedInputStream in = new BufferedInputStream(conn.getInputStream());){
                JSONObject jsonObject = JSONObject.fromObject((Object)this.getResponseBody(in));
                String version = jsonObject.getString(PROJECT_LOOKUP_VERSION_PARAM);
                Project.ProjectBuilder builder = Project.builder().name(jsonObject.getString(PROJECT_LOOKUP_NAME_PARAM)).uuid(jsonObject.getString("uuid"));
                if (StringUtils.isNotBlank((String)version) && !"null".equalsIgnoreCase(version)) {
                    builder.version(version);
                }
                Project project = builder.build();
                return project;
            }
        }
        catch (ApiClientException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ApiClientException(Messages.ApiClient_Error_ProjectLookup(projectName, projectVersion, "", ""), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public List<Finding> getFindings(String projectUuid) throws ApiClientException {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(this.baseUrl + PROJECT_FINDINGS_URL + "/" + URLEncoder.encode(projectUuid, StandardCharsets.UTF_8.name())).openConnection();
            conn.setDoOutput(true);
            conn.setRequestProperty(API_KEY_HEADER, this.apiKey);
            conn.setRequestProperty(HEADER_ACCEPT, MEDIATYPE_JSON);
            conn.setConnectTimeout(this.connectionTimeout * 1000);
            conn.setReadTimeout(this.readTimeout * 1000);
            conn.connect();
            if (conn.getResponseCode() != 200) {
                this.logHttpError(conn);
                throw new ApiClientException(Messages.ApiClient_Error_RetrieveFindings(conn.getResponseCode(), conn.getResponseMessage()));
            }
            try (BufferedInputStream in = new BufferedInputStream(conn.getInputStream());){
                List<Finding> list = FindingParser.parse(this.getResponseBody(in));
                return list;
            }
        }
        catch (ApiClientException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ApiClientException(Messages.ApiClient_Error_RetrieveFindings("", ""), e);
        }
    }

    @NonNull
    public UploadResult upload(String projectId, String projectName, String projectVersion, FilePath artifact, boolean autoCreateProject) throws IOException {
        String encodedScan;
        try {
            encodedScan = Base64.encodeBase64String((byte[])artifact.readToString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException | InterruptedException e) {
            this.logger.log(Messages.Builder_Error_Processing(artifact.getRemote(), e.getLocalizedMessage()));
            return new UploadResult(false);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.element("bom", (Object)encodedScan);
        if (projectId != null) {
            jsonObject.element("project", (Object)projectId);
        } else {
            jsonObject.element("projectName", (Object)projectName).element("projectVersion", (Object)projectVersion).element("autoCreate", autoCreateProject);
        }
        byte[] payloadBytes = jsonObject.toString().getBytes(StandardCharsets.UTF_8);
        HttpURLConnection conn = (HttpURLConnection)new URL(this.baseUrl + BOM_URL).openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("PUT");
        conn.setRequestProperty(HEADER_CONTENT_TYPE, MEDIATYPE_JSON);
        conn.setRequestProperty(HEADER_ACCEPT, MEDIATYPE_JSON);
        conn.setConnectTimeout(this.connectionTimeout * 1000);
        conn.setReadTimeout(this.readTimeout * 1000);
        conn.setRequestProperty("Content-Length", Integer.toString(payloadBytes.length));
        conn.setRequestProperty(API_KEY_HEADER, this.apiKey);
        conn.connect();
        try (BufferedOutputStream os = new BufferedOutputStream(conn.getOutputStream());){
            ((OutputStream)os).write(payloadBytes);
            ((OutputStream)os).flush();
        }
        catch (IOException e) {
            this.logger.log(Messages.Builder_Error_Processing(artifact.getRemote(), e.getLocalizedMessage()));
            return new UploadResult(false);
        }
        switch (conn.getResponseCode()) {
            case 200: {
                try (BufferedInputStream in = new BufferedInputStream(conn.getInputStream());){
                    String responseBody = this.getResponseBody(in);
                    if (StringUtils.isNotBlank((String)responseBody)) {
                        JSONObject json = JSONObject.fromObject((Object)responseBody);
                        UploadResult uploadResult = new UploadResult(true, StringUtils.trimToNull((String)json.getString("token")));
                        return uploadResult;
                    }
                    UploadResult uploadResult = new UploadResult(true);
                    return uploadResult;
                }
            }
            case 400: {
                this.logger.log(Messages.Builder_Payload_Invalid());
                this.logHttpError(conn);
                break;
            }
            case 401: {
                this.logger.log(Messages.Builder_Unauthorized());
                this.logHttpError(conn);
                break;
            }
            case 404: {
                this.logger.log(Messages.Builder_Project_NotFound());
                this.logHttpError(conn);
                break;
            }
            default: {
                this.logger.log(Messages.ApiClient_Error_Connection(conn.getResponseCode(), conn.getResponseMessage()));
                this.logHttpError(conn);
            }
        }
        return new UploadResult(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public boolean isTokenBeingProcessed(String token) throws ApiClientException {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(this.baseUrl + BOM_TOKEN_URL + "/" + URLEncoder.encode(token, StandardCharsets.UTF_8.name())).openConnection();
            conn.setDoOutput(true);
            conn.setRequestProperty(API_KEY_HEADER, this.apiKey);
            conn.setRequestProperty(HEADER_ACCEPT, MEDIATYPE_JSON);
            conn.setConnectTimeout(this.connectionTimeout * 1000);
            conn.setReadTimeout(this.readTimeout * 1000);
            conn.connect();
            if (conn.getResponseCode() != 200) {
                this.logger.log(Messages.ApiClient_Error_TokenProcessing(conn.getResponseCode(), conn.getResponseMessage()));
                this.logHttpError(conn);
                throw new ApiClientException(Messages.ApiClient_Error_TokenProcessing(conn.getResponseCode(), conn.getResponseMessage()));
            }
            try (BufferedInputStream in = new BufferedInputStream(conn.getInputStream());){
                JSONObject jsonObject = JSONObject.fromObject((Object)this.getResponseBody(in));
                boolean bl = jsonObject.getBoolean("processing");
                return bl;
            }
        }
        catch (ApiClientException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ApiClientException(Messages.ApiClient_Error_TokenProcessing("", ""), e);
        }
    }

    private String getResponseBody(InputStream in) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        return reader.lines().collect(Collectors.joining());
    }

    private void logHttpError(HttpURLConnection conn) {
        try (BufferedInputStream in = new BufferedInputStream(conn.getErrorStream());){
            this.logger.log(this.getResponseBody(in));
        }
        catch (IOException | UncheckedIOException exception) {
            // empty catch block
        }
    }

    @Generated
    public ApiClient(String baseUrl, String apiKey, ConsoleLogger logger, int connectionTimeout, int readTimeout) {
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.logger = logger;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }
}

