/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import com.delphix.dct.models.ProvisionVDBBySnapshotParameters;
import com.delphix.dct.models.ProvisionVDBFromBookmarkParameters;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.HashSet;

public class ValidationUtil {
    private TypeAdapter<JsonObject> strictGsonObjectAdapter = new Gson().getAdapter(JsonObject.class);
    private JsonObject result = null;
    private HashSet<String> snapshotFieldSet = new HashSet();
    private HashSet<String> bookmarkFieldSet = new HashSet();

    public void validateJsonFormat(String json) {
        try {
            JsonReader reader = new JsonReader((Reader)new StringReader(json));
            this.result = (JsonObject)this.strictGsonObjectAdapter.read(reader);
        }
        catch (IOException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }

    public String validateJsonWithSnapshotProvisionParameters() {
        if (this.result != null) {
            Field[] provisionSnapshotFields = ProvisionVDBBySnapshotParameters.class.getDeclaredFields();
            for (Field x : provisionSnapshotFields) {
                SerializedName sName = x.getAnnotation(SerializedName.class);
                if (sName == null) continue;
                this.snapshotFieldSet.add(sName.value());
            }
            for (String jsonKey : this.result.keySet()) {
                if (this.snapshotFieldSet.contains(jsonKey)) continue;
                return jsonKey;
            }
            return null;
        }
        return null;
    }

    public String validateJsonWithBookmarkProvisionParameters() {
        if (this.result != null) {
            Field[] provisionBookmarkFields = ProvisionVDBFromBookmarkParameters.class.getDeclaredFields();
            for (Field x : provisionBookmarkFields) {
                SerializedName sName = x.getAnnotation(SerializedName.class);
                if (sName == null) continue;
                this.bookmarkFieldSet.add(sName.value());
            }
            for (String jsonKey : this.result.keySet()) {
                if (this.bookmarkFieldSet.contains(jsonKey)) continue;
                return jsonKey;
            }
            return null;
        }
        return null;
    }
}

