/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.delphix;

import hudson.model.AbstractProject;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.delphix.DelphixEngine;
import io.jenkins.plugins.delphix.DelphixEngineException;
import io.jenkins.plugins.delphix.GlobalConfiguration;
import io.jenkins.plugins.delphix.Messages;
import io.jenkins.plugins.delphix.objects.SelfServiceBookmark;
import io.jenkins.plugins.delphix.objects.SelfServiceContainer;
import io.jenkins.plugins.delphix.repos.SelfServiceBookmarkRepository;
import io.jenkins.plugins.delphix.repos.SelfServiceRepository;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.kohsuke.stapler.QueryParameter;

public abstract class SelfServiceDescriptor
extends BuildStepDescriptor<Builder> {
    public SelfServiceDescriptor() {
        this.load();
    }

    public ListBoxModel doFillDelphixEngineItems() {
        return DelphixEngine.fillEnginesForDropdown();
    }

    private ListBoxModel fillItems(String delphixEngine, String itemType) {
        ArrayList<ListBoxModel.Option> options = new ArrayList<ListBoxModel.Option>();
        if (delphixEngine.equals("NULL") || delphixEngine.equals(" ")) {
            options.add(new ListBoxModel.Option("N/A", "NULL"));
            return new ListBoxModel(options);
        }
        if (delphixEngine.isEmpty()) {
            return new ListBoxModel(options);
        }
        SelfServiceRepository engine = new SelfServiceRepository(GlobalConfiguration.getPluginClassDescriptor().getEngine(delphixEngine));
        try {
            try {
                engine.login();
                switch (itemType) {
                    case "SelfService": {
                        LinkedHashMap<String, SelfServiceContainer> environments = engine.listSelfServices();
                        for (SelfServiceContainer environment : environments.values()) {
                            options.add(new ListBoxModel.Option(environment.getName(), environment.getReference()));
                        }
                        break;
                    }
                    case "Bookmark": {
                        SelfServiceBookmarkRepository bookmarkRepo = new SelfServiceBookmarkRepository(engine);
                        bookmarkRepo.login();
                        LinkedHashMap<String, SelfServiceBookmark> bookmarks = bookmarkRepo.listBookmarks();
                        for (SelfServiceBookmark bookmark : bookmarks.values()) {
                            options.add(new ListBoxModel.Option(bookmark.getName(), bookmark.getReference()));
                        }
                        break;
                    }
                    default: {
                        throw new DelphixEngineException("Invalid Self Service Item Type");
                    }
                }
            }
            catch (DelphixEngineException e) {
                options.add(new ListBoxModel.Option(Messages.getMessage("unable.to.login", new String[]{engine.getEngineAddress()}), "NULL"));
            }
        }
        catch (IOException e) {
            options.add(new ListBoxModel.Option(Messages.getMessage("unable.to.connect", new String[]{engine.getEngineAddress()}), "NULL"));
        }
        return new ListBoxModel(options);
    }

    public ListBoxModel doFillDelphixSelfServiceItems(@QueryParameter String delphixEngine) {
        return this.fillItems(delphixEngine, "SelfService");
    }

    public ListBoxModel doFillDelphixBookmarkItems(@QueryParameter String delphixEngine) {
        return this.fillItems(delphixEngine, "Bookmark");
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }
}

