/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.delphix;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.delphix.DelphixBuilder;
import io.jenkins.plugins.delphix.DelphixEngine;
import io.jenkins.plugins.delphix.DelphixEngineException;
import io.jenkins.plugins.delphix.DelphixProperties;
import io.jenkins.plugins.delphix.GlobalConfiguration;
import io.jenkins.plugins.delphix.Messages;
import io.jenkins.plugins.delphix.SelfServiceDescriptor;
import io.jenkins.plugins.delphix.objects.SelfServiceContainer;
import io.jenkins.plugins.delphix.objects.User;
import io.jenkins.plugins.delphix.repos.SelfServiceRepository;
import io.jenkins.plugins.delphix.repos.UserRepository;
import java.io.IOException;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class SelfServiceContainerBuilder
extends DelphixBuilder
implements SimpleBuildStep {
    private final String delphixEngine;
    private final String delphixEnvironment;
    private final String delphixOperation;
    private final String delphixBookmark;
    private boolean saveToProps;
    private boolean loadFromProps;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @DataBoundConstructor
    public SelfServiceContainerBuilder(String delphixEngine, String delphixEnvironment, String delphixOperation, String delphixBookmark) {
        this.delphixEngine = delphixEngine;
        this.delphixEnvironment = delphixEnvironment;
        this.delphixOperation = delphixOperation;
        this.delphixBookmark = delphixBookmark;
    }

    public String getDelphixEngine() {
        return this.delphixEngine;
    }

    public String getDelphixEnvironment() {
        return this.delphixEnvironment;
    }

    public String getDelphixOperation() {
        return this.delphixOperation;
    }

    public String getDelphixBookmark() {
        return this.delphixBookmark;
    }

    public boolean getSaveToProps() {
        return this.saveToProps;
    }

    public boolean getLoadFromProps() {
        return this.loadFromProps;
    }

    @DataBoundSetter
    public void setSaveToProps(boolean saveToProps) {
        this.saveToProps = saveToProps;
    }

    @DataBoundSetter
    public void setLoadFromProps(boolean loadFromProps) {
        this.loadFromProps = loadFromProps;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        if (this.delphixEnvironment.equals("NULL")) {
            listener.getLogger().println(Messages.getMessage("invalid.engine.environment"));
        }
        String engine = this.delphixEngine;
        String selfServiceContainer = this.delphixEnvironment;
        String operationType = this.delphixOperation;
        String bookmark = this.delphixBookmark;
        DelphixProperties delphixProps = new DelphixProperties(workspace, listener);
        if (this.loadFromProps) {
            try {
                bookmark = delphixProps.getBookmarkReference();
            }
            catch (Throwable t) {
                listener.getLogger().println(t.getMessage());
            }
        }
        if (this.saveToProps) {
            delphixProps.setContainerReference(selfServiceContainer);
        }
        if (GlobalConfiguration.getPluginClassDescriptor().getEngine(engine) == null) {
            listener.getLogger().println(Messages.getMessage("invalid.engine.environment"));
        }
        DelphixEngine loadedEngine = GlobalConfiguration.getPluginClassDescriptor().getEngine(engine);
        SelfServiceRepository delphixEngine = new SelfServiceRepository(loadedEngine);
        UserRepository userRepo = new UserRepository(loadedEngine);
        ObjectNode action = MAPPER.createObjectNode();
        try {
            delphixEngine.login();
            switch (operationType) {
                case "Refresh": {
                    action = delphixEngine.refresh(selfServiceContainer);
                    break;
                }
                case "Reset": {
                    action = delphixEngine.reset(selfServiceContainer);
                    break;
                }
                case "Restore": {
                    action = delphixEngine.restore(selfServiceContainer, bookmark);
                    break;
                }
                case "Enable": {
                    action = delphixEngine.enable(selfServiceContainer);
                    break;
                }
                case "Disable": {
                    action = delphixEngine.disable(selfServiceContainer);
                    break;
                }
                case "Recover": {
                    action = delphixEngine.recover(selfServiceContainer);
                    break;
                }
                case "Undo": {
                    SelfServiceContainer container = delphixEngine.get(selfServiceContainer);
                    action = delphixEngine.undo(selfServiceContainer, container.getLastOperation());
                    break;
                }
                case "Lock": {
                    userRepo.login();
                    User user = userRepo.getCurrent();
                    action = delphixEngine.lock(selfServiceContainer, user.getReference());
                    break;
                }
                case "Unlock": {
                    action = delphixEngine.unlock(selfServiceContainer);
                    break;
                }
                default: {
                    throw new DelphixEngineException("Undefined Self Service Operation");
                }
            }
        }
        catch (DelphixEngineException e) {
            listener.getLogger().println(e.getMessage());
        }
        catch (IOException e) {
            listener.getLogger().println(Messages.getMessage("unable.to.connect", new String[]{delphixEngine.getEngineAddress()}));
        }
        if (this.checkActionIsFinished(listener, loadedEngine, (JsonNode)action).booleanValue()) {
            return;
        }
        String job = action.get("job").asText();
        this.checkJobStatus(run, listener, loadedEngine, job, engine, selfServiceContainer);
    }

    @Extension
    public static final class RefreshDescriptor
    extends SelfServiceDescriptor {
        @Override
        public ListBoxModel doFillDelphixEngineItems() {
            return super.doFillDelphixEngineItems();
        }

        public ListBoxModel doFillDelphixEnvironmentItems(@QueryParameter String delphixEngine) {
            return super.doFillDelphixSelfServiceItems(delphixEngine);
        }

        @Override
        public ListBoxModel doFillDelphixBookmarkItems(@QueryParameter String delphixEngine) {
            return super.doFillDelphixBookmarkItems(delphixEngine);
        }

        public ListBoxModel doFillDelphixOperationItems() {
            ListBoxModel operations = new ListBoxModel();
            operations.add("Refresh", "Refresh");
            operations.add("Restore", "Restore");
            operations.add("Enable", "Enable");
            operations.add("Disable", "Disable");
            operations.add("Recover", "Recover");
            operations.add("Reset", "Reset");
            operations.add("Undo", "Undo");
            operations.add("Lock", "Lock");
            operations.add("Unlock", "Unlock");
            return operations;
        }

        public String getDisplayName() {
            return Messages.getMessage("selfservice.operation");
        }
    }
}

