/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.delphix;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.util.FormValidation;
import io.jenkins.plugins.delphix.DelphixEngine;
import io.jenkins.plugins.delphix.DelphixEngineException;
import io.jenkins.plugins.delphix.Messages;
import java.io.IOException;
import java.util.ArrayList;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class GlobalConfiguration
extends JobProperty<Job<?, ?>> {
    private static final String ENGINE_ADDRESS = "engineAddress";
    private static final String ENGINE_USERNAME = "engineUsername";
    private static final String ENGINE_PASSWORD = "enginePassword";

    public static DescriptorImpl getPluginClassDescriptor() {
        Jenkins instance = Jenkins.getInstance();
        if (instance != null) {
            return (DescriptorImpl)instance.getDescriptor(GlobalConfiguration.class);
        }
        throw new IllegalStateException();
    }

    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private ArrayList<DelphixEngine> engines = new ArrayList();

        public DescriptorImpl() {
            super(GlobalConfiguration.class);
            this.load();
        }

        @DataBoundConstructor
        public DescriptorImpl(ArrayList<DelphixEngine> engines) {
            this.engines = engines;
        }

        public String getDisplayName() {
            return "Delphix";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.engines = new ArrayList();
            Object engine = formData.get("engine");
            if (engine instanceof JSONObject) {
                this.addEngine((JSONObject)engine);
            } else if (engine instanceof JSONArray) {
                JSONArray engines = (JSONArray)engine;
                for (int i = 0; i < engines.size(); ++i) {
                    this.addEngine(engines.getJSONObject(i));
                }
            } else {
                this.engines = new ArrayList();
            }
            this.save();
            return super.configure(req, formData);
        }

        public FormValidation doTestConnection(@QueryParameter(value="engineAddress") String engineAddress, @QueryParameter(value="engineUsername") String engineUsername, @QueryParameter(value="enginePassword") String enginePassword) {
            DelphixEngine engine = new DelphixEngine(engineAddress, engineUsername, enginePassword);
            try {
                try {
                    engine.login();
                    return FormValidation.ok((String)Messages.getMessage("test.login.success"));
                }
                catch (DelphixEngineException e) {
                    return FormValidation.error((String)Messages.getMessage("test.login.failure"));
                }
            }
            catch (IOException e) {
                return FormValidation.error((String)Messages.getMessage("test.login.connect"));
            }
        }

        private void addEngine(JSONObject engineJson) {
            String address = engineJson.getString(GlobalConfiguration.ENGINE_ADDRESS);
            String user = engineJson.getString(GlobalConfiguration.ENGINE_USERNAME);
            String password = engineJson.getString(GlobalConfiguration.ENGINE_PASSWORD);
            this.engines.add(new DelphixEngine(address, user, password));
        }

        public ArrayList<DelphixEngine> getEngines() {
            return this.engines;
        }

        public DelphixEngine getEngine(String address) {
            for (DelphixEngine engine : this.engines) {
                if (!engine.getEngineAddress().equals(address)) continue;
                return engine;
            }
            return null;
        }
    }
}

