/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.delphix;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.delphix.DelphixEngineException;
import io.jenkins.plugins.delphix.GlobalConfiguration;
import io.jenkins.plugins.delphix.Messages;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class DelphixEngine {
    private static final Logger LOGGER = Logger.getLogger(DelphixEngine.class.getName());
    private static final String PROTOCOL = "http://";
    private static final String ENCODING = "UTF-8";
    private static final String CONTENT_TYPE = "application/json";
    private static final String OK_STATUS = "OK";
    private static final String PATH_SESSION = "/resources/json/delphix/session";
    private static final String PATH_LOGIN = "/resources/json/delphix/login";
    private static final String PATH_ENVIRONMENT = "/resources/json/delphix/environment";
    private static final String CONTENT_SESSION = "{\"type\": \"APISession\",\"version\": {\"type\": \"APIVersion\",\"major\": %s,\"minor\": %s,\"micro\": %s}}";
    private static final String CONTENT_LOGIN = "{\"type\": \"LoginRequest\",\"username\": \"%s\",\"password\": \"%s\"}";
    private static final String CONTENT_ADD_UNIX_ENVIRONMENT = "{\"type\": \"HostEnvironmentCreateParameters\",\"primaryUser\": {\"type\": \"EnvironmentUser\",\"name\": \"%s\",\"credential\": {\"type\": \"PasswordCredential\",\"password\": \"%s\"}},\"hostEnvironment\": {\"type\": \"UnixHostEnvironment\"},\"hostParameters\": {\"type\": \"UnixHostCreateParameters\",\"host\": {\"type\": \"UnixHost\",\"address\": \"%s\",\"toolkitPath\": \"%s\"}}}";
    public static final String CONTENT_LATEST_POINT = "LATEST_POINT";
    public static final String CONTENT_LATEST_SNAPSHOT = "LATEST_SNAPSHOT";
    public static final String CONTENT_SYNC_HOOK = "{\"operations\":{\"preSync\":%s,\"postSync\":%s, \"type\": \"%s\"},\"type\":\"%s\"}";
    public static final String CONTENT_REFRESH_HOOK = "{\"operations\":{\"preRefresh\":%s,\"postRefresh\":%s, \"type\": \"%s\"},\"type\":\"%s\"}";
    public static final String CONTENT_ROLLBACK_HOOK = "{\"operations\":{\"preRollback\":%s,\"postRollback\":%s, \"type\": \"%s\"},\"type\":\"%s\"}";
    public static final String CONTENT_COMPATIBLE_REPOSITORIES = "{\"environment\": \"%s\", \"timeflowPointParameters\":%s,\"type\":\"ProvisionCompatibilityParameters\"}";
    protected static final String FIELD_RESULT = "result";
    protected static final String FIELD_JOB = "job";
    protected static final String FIELD_NAME = "name";
    protected static final String FIELD_REFERENCE = "reference";
    private static final String FIELD_STATUS = "status";
    private String JSESSIONID = "";
    private final String engineAddress;
    private final String engineUsername;
    private final String enginePassword;
    private final HttpClient client;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @DataBoundConstructor
    public DelphixEngine(String engineAddress, String engineUsername, String enginePassword) {
        this.engineAddress = engineAddress;
        this.engineUsername = engineUsername;
        this.enginePassword = enginePassword;
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        requestBuilder = requestBuilder.setConnectTimeout(60000);
        requestBuilder = requestBuilder.setConnectionRequestTimeout(60000);
        requestBuilder = requestBuilder.setSocketTimeout(60000);
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultRequestConfig(requestBuilder.build());
        this.client = builder.build();
    }

    public DelphixEngine(DelphixEngine engine) {
        this.engineAddress = engine.engineAddress;
        this.engineUsername = engine.engineUsername;
        this.enginePassword = engine.enginePassword;
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        requestBuilder = requestBuilder.setConnectTimeout(60000);
        requestBuilder = requestBuilder.setConnectionRequestTimeout(60000);
        requestBuilder = requestBuilder.setSocketTimeout(60000);
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultRequestConfig(requestBuilder.build());
        this.client = builder.build();
    }

    private String buildUrl(String engineAddress, String path) {
        if (engineAddress.startsWith("http") || engineAddress.startsWith("https")) {
            return engineAddress + path;
        }
        return PROTOCOL + engineAddress + path;
    }

    private String getCookie() {
        return this.JSESSIONID;
    }

    private void checkCookie(HttpResponse response) {
        if (response.containsHeader("Set-Cookie")) {
            this.JSESSIONID = response.getFirstHeader("Set-Cookie").getValue();
        }
    }

    protected JsonNode enginePost(String path, String content) throws IOException, DelphixEngineException {
        if (!content.contains("LoginRequest")) {
            LOGGER.log(Level.WARNING, path + ":" + content);
        }
        HttpPost request = new HttpPost(this.buildUrl(this.engineAddress, path));
        try {
            request.setEntity((HttpEntity)new ByteArrayEntity(content.getBytes(ENCODING)));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        request.setHeader("Content-Type", CONTENT_TYPE);
        request.setHeader("Cookie", this.getCookie());
        HttpResponse response = this.client.execute((HttpUriRequest)request);
        this.checkCookie(response);
        String result = EntityUtils.toString((HttpEntity)response.getEntity());
        JsonNode jsonResult = MAPPER.readTree(result);
        EntityUtils.consume((HttpEntity)response.getEntity());
        if (!jsonResult.get(FIELD_STATUS).asText().equals(OK_STATUS)) {
            throw new DelphixEngineException(jsonResult.get("error").get("details").toString());
        }
        if (!content.contains("LoginRequest")) {
            LOGGER.log(Level.WARNING, jsonResult.toString());
        }
        return jsonResult;
    }

    protected JsonNode engineGet(String path) throws IOException, DelphixEngineException {
        LOGGER.log(Level.WARNING, path);
        HttpGet request = new HttpGet(this.buildUrl(this.engineAddress, path));
        request.setHeader("Content-Type", CONTENT_TYPE);
        request.setHeader("Cookie", this.getCookie());
        HttpResponse response = this.client.execute((HttpUriRequest)request);
        this.checkCookie(response);
        String result = EntityUtils.toString((HttpEntity)response.getEntity());
        JsonNode jsonResult = MAPPER.readTree(result);
        EntityUtils.consume((HttpEntity)response.getEntity());
        if (!jsonResult.get(FIELD_STATUS).asText().equals(OK_STATUS)) {
            throw new DelphixEngineException(jsonResult.get("error").get("details").asText());
        }
        LOGGER.log(Level.WARNING, jsonResult.toString());
        return jsonResult;
    }

    public void login() throws IOException, DelphixEngineException {
        this.enginePost(PATH_SESSION, String.format(CONTENT_SESSION, "1", "7", "0"));
        this.enginePost(PATH_LOGIN, String.format(CONTENT_LOGIN, this.engineUsername, this.enginePassword));
    }

    public String createEnvironment(String address, String user, String password, String toolkit) throws IOException, DelphixEngineException {
        JsonNode result = this.enginePost(PATH_ENVIRONMENT, String.format(CONTENT_ADD_UNIX_ENVIRONMENT, user, password, address, toolkit));
        return result.get(FIELD_JOB).asText();
    }

    public String getEngineAddress() {
        return this.engineAddress;
    }

    public String getEngineUsername() {
        return this.engineUsername;
    }

    public String getEnginePassword() {
        return this.enginePassword;
    }

    public static ListBoxModel fillEnginesForDropdown() {
        ArrayList<ListBoxModel.Option> options = new ArrayList<ListBoxModel.Option>();
        for (DelphixEngine engine : GlobalConfiguration.getPluginClassDescriptor().getEngines()) {
            DelphixEngine delphixEngine = new DelphixEngine(engine);
            try {
                try {
                    delphixEngine.login();
                    options.add(new ListBoxModel.Option(delphixEngine.getEngineAddress(), delphixEngine.getEngineAddress()));
                }
                catch (DelphixEngineException e) {
                    options.add(new ListBoxModel.Option(Messages.getMessage("unable.to.login", new String[]{delphixEngine.getEngineAddress()}), "NULL"));
                }
            }
            catch (IOException e) {
                options.add(new ListBoxModel.Option(Messages.getMessage("unable.to.connect", new String[]{delphixEngine.getEngineAddress()}), "NULL"));
            }
        }
        if (GlobalConfiguration.getPluginClassDescriptor().getEngines().size() == 0) {
            options.add(new ListBoxModel.Option(Messages.getMessage("no.engines"), "NULL"));
        }
        return new ListBoxModel(options);
    }
}

