/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.delphix;

import com.fasterxml.jackson.databind.JsonNode;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import io.jenkins.plugins.delphix.DelphixEngine;
import io.jenkins.plugins.delphix.DelphixEngineException;
import io.jenkins.plugins.delphix.Messages;
import io.jenkins.plugins.delphix.PublishEnvVarAction;
import io.jenkins.plugins.delphix.objects.Action;
import io.jenkins.plugins.delphix.objects.Job;
import io.jenkins.plugins.delphix.repos.ActionRepository;
import io.jenkins.plugins.delphix.repos.JobRepository;
import java.io.IOException;

public abstract class DelphixBuilder
extends Builder {
    protected Boolean checkActionIsFinished(TaskListener listener, DelphixEngine engine, JsonNode action) {
        Boolean status = false;
        try {
            ActionRepository actionRepo = new ActionRepository(engine);
            actionRepo.login();
            Action actionStatus = actionRepo.get(action.get("action").asText());
            if (actionStatus.getState().equals("COMPLETED")) {
                String message = actionStatus.getTitle() + ": " + actionStatus.getState();
                listener.getLogger().println(message);
                status = true;
            }
        }
        catch (DelphixEngineException e) {
            listener.getLogger().println(e.getMessage());
        }
        catch (IOException e) {
            listener.getLogger().println(Messages.getMessage("unable.to.connect", new String[]{engine.getEngineAddress()}));
        }
        return status;
    }

    protected void checkJobStatus(Run<?, ?> run, TaskListener listener, DelphixEngine loadedEngine, String job, String engine, String action) {
        Job status;
        run.addAction((hudson.model.Action)new PublishEnvVarAction(action, engine));
        run.addAction((hudson.model.Action)new PublishEnvVarAction(job, engine));
        Job lastStatus = status = new Job(Job.StatusEnum.RUNNING, "type", "reference", "namespace", "name", "actionType", "target", "targetObjectType", "jobState", "startTime", "updateTime", false, false, false, "user", "emailAddresses", "title", 0, "targetName", "parentActionState", "parentAction");
        JobRepository jobRepo = new JobRepository(loadedEngine);
        while (status.getStatus().equals((Object)Job.StatusEnum.RUNNING)) {
            try {
                jobRepo.login();
                status = jobRepo.get(job);
            }
            catch (DelphixEngineException e) {
                listener.getLogger().println(e.getMessage());
            }
            catch (IOException e) {
                listener.getLogger().println(Messages.getMessage("unable.to.connect", new String[]{loadedEngine.getEngineAddress()}));
            }
            if (!status.getPercentComplete().equals(lastStatus.getPercentComplete())) {
                listener.getLogger().println(status.getActionType() + " " + status.getReference() + ": " + status.getPercentComplete() + "% COMPLETED.");
            }
            lastStatus = status;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                listener.getLogger().println(e.getMessage());
            }
        }
    }
}

