/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dbcharts;

import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JDBCConnection
implements Serializable {
    private static final long serialVersionUID = -7258724749798334055L;
    public final String name;
    public final String url;
    public final String user;
    public final String passwd;

    @DataBoundConstructor
    public JDBCConnection(String name, String url, String user, String passwd) {
        this.name = name;
        this.url = url;
        this.user = user;
        this.passwd = passwd;
    }

    public JDBCConnection(JSONObject o) {
        this.name = o.getString("name");
        this.url = o.getString("url");
        this.user = o.getString("user");
        this.passwd = o.getString("passwd");
    }

    public List<String> getDrivers() {
        Enumeration<Driver> e = DriverManager.getDrivers();
        LinkedList<String> res = new LinkedList<String>();
        while (e.hasMoreElements()) {
            res.add(e.nextElement().getClass().getCanonicalName());
        }
        return res;
    }

    public abstract String getDriver();

    public Connection createConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.user, this.passwd);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class JDBCConnectionDescriptor<T extends Describable<T>>
    extends Descriptor<T> {
        public FormValidation doCheckName(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a name");
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)"Isn't the name too short?");
            }
            return FormValidation.ok();
        }

        public void doTestConnection(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="driver") String driver, @QueryParameter(value="url") String url, @QueryParameter(value="user") String user, @QueryParameter(value="passwd") String passwd) throws IOException, ServletException {
            try {
                Class<?> dc = Class.forName(driver);
                Driver d = (Driver)dc.newInstance();
                if (!d.acceptsURL(url)) {
                    FormValidation.error((String)("Driver: " + driver + " does not accept:" + url)).generateResponse(req, rsp, (Object)this);
                } else {
                    DriverManager.getConnection(url, user, passwd);
                    FormValidation.ok((String)"Connection OK").generateResponse(req, rsp, (Object)this);
                }
            }
            catch (SQLException e) {
                FormValidation.error((String)e.getMessage()).generateResponse(req, rsp, (Object)this);
            }
            catch (ClassNotFoundException e) {
                FormValidation.error((String)("Class not found:" + e.getMessage())).generateResponse(req, rsp, (Object)this);
            }
            catch (InstantiationException e) {
                FormValidation.error((String)("Cannot create instance of:" + e.getMessage())).generateResponse(req, rsp, (Object)this);
            }
            catch (IllegalAccessException e) {
                FormValidation.error((String)e.getMessage()).generateResponse(req, rsp, (Object)this);
            }
        }
    }
}

