/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.database;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.TopLevelItem;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.database.PerItemDatabase;
import org.jenkinsci.plugins.database.PerItemDatabaseDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

@Extension(ordinal=-32.99500000011176)
public class PerItemDatabaseConfiguration
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(PerItemDatabaseConfiguration.class.getName());
    private volatile PerItemDatabase database;

    public PerItemDatabaseConfiguration() {
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public PerItemDatabase getDatabase() {
        if (this.database != null) {
            return this.database;
        }
        PerItemDatabaseConfiguration perItemDatabaseConfiguration = this;
        synchronized (perItemDatabaseConfiguration) {
            if (this.database != null) {
                return this.database;
            }
            for (PerItemDatabaseDescriptor d : Jenkins.getInstance().getExtensionList(PerItemDatabaseDescriptor.class)) {
                for (Constructor<?> c : d.clazz.getConstructors()) {
                    if (c.getParameterTypes().length != 0 || c.getAnnotation(DataBoundConstructor.class) == null) continue;
                    LOGGER.log(Level.INFO, "no configured database; falling back to {0}", d.getId());
                    try {
                        this.database = (PerItemDatabase)((Object)c.newInstance(new Object[0]));
                        this.save();
                        return this.database;
                    }
                    catch (Exception x) {
                        LOGGER.log(Level.WARNING, "cannot create no-arg instance of " + d.getId(), x);
                    }
                }
            }
            return null;
        }
    }

    public void setDatabase(PerItemDatabase database) {
        this.database = database;
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        this.save();
        return true;
    }

    @CheckForNull
    public static PerItemDatabase findOrNull() {
        PerItemDatabaseConfiguration database = (PerItemDatabaseConfiguration)((Object)PerItemDatabaseConfiguration.all().get(PerItemDatabaseConfiguration.class));
        return database != null ? database.getDatabase() : null;
    }

    @Nonnull
    public static PerItemDatabase find() {
        PerItemDatabase database = PerItemDatabaseConfiguration.findOrNull();
        return database != null ? database : new PerItemDatabase(){

            @Override
            public DataSource getDataSource(TopLevelItem item) throws SQLException {
                throw new SQLException("No per-item database has been configured");
            }
        };
    }
}

