/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.database;

import hudson.Extension;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.File;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import jenkins.model.Jenkins;
import org.apache.tools.ant.AntClassLoader;
import org.jenkinsci.plugins.database.BasicDataSource2;
import org.jenkinsci.plugins.database.Database;
import org.jenkinsci.plugins.database.DatabaseDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class GenericDatabase
extends Database {
    public final String driver;
    public final String username;
    public final Secret password;
    public final String url;
    private transient DataSource source;

    @DataBoundConstructor
    public GenericDatabase(String url, String driver, String username, Secret password) {
        this.url = url;
        this.driver = driver;
        this.username = username;
        this.password = password;
    }

    @Override
    public synchronized DataSource getDataSource() throws SQLException {
        if (this.source == null) {
            BasicDataSource2 source = new BasicDataSource2();
            source.setDriverClassLoader(this.getDescriptor().getClassLoader());
            source.setDriverClassName(this.driver);
            source.setUrl(this.url);
            source.setUsername(this.username);
            source.setPassword(Secret.toString((Secret)this.password));
            this.source = source.createDataSource();
        }
        return this.source;
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension(ordinal=-1000.0)
    public static class DescriptorImpl
    extends DatabaseDescriptor {
        private transient AntClassLoader loader;

        public String getDisplayName() {
            return "Generic";
        }

        private synchronized ClassLoader getClassLoader() {
            if (this.loader == null) {
                this.loader = new AntClassLoader(HttpServletRequest.class.getClassLoader(), true);
                File[] files = new File(Jenkins.getInstance().getRootDir(), "jdbc-drivers").listFiles();
                if (files != null) {
                    for (File jar : files) {
                        if (!jar.getName().endsWith(".jar")) continue;
                        this.loader.addPathComponent(jar);
                    }
                }
            }
            return this.loader;
        }

        public FormValidation doCheckDriver(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.ok();
            }
            try {
                this.getClassLoader().loadClass(value);
                return FormValidation.ok();
            }
            catch (ClassNotFoundException e) {
                return FormValidation.error((String)("No such class: " + value));
            }
        }

        public FormValidation doValidate(@QueryParameter String driver, @QueryParameter String url, @QueryParameter String username, @QueryParameter String password) {
            try {
                new GenericDatabase(url, driver, username, Secret.fromString((String)password)).getDataSource();
                return FormValidation.ok((String)"OK");
            }
            catch (SQLException e) {
                return FormValidation.error((Throwable)e, (String)"Failed to connect");
            }
        }
    }
}

