/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard.test;

import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.plugins.view.dashboard.test.TestResult;
import hudson.plugins.view.dashboard.test.TestResultSummary;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import java.util.Collection;

public class TestUtil {
    public static TestResultSummary getTestResultSummary(Collection<TopLevelItem> jobs, boolean hideZeroTestProjects) {
        TestResultSummary summary = new TestResultSummary();
        for (TopLevelItem item : jobs) {
            if (item instanceof MatrixProject) {
                MatrixProject mp = (MatrixProject)item;
                for (MatrixConfiguration configuration : mp.getActiveConfigurations()) {
                    MatrixConfiguration job = mp.getItem(configuration.getCombination());
                    TestUtil.summarizeJob((Job)job, summary, hideZeroTestProjects);
                }
                continue;
            }
            if (!(item instanceof Job)) continue;
            Job job = (Job)item;
            TestUtil.summarizeJob(job, summary, hideZeroTestProjects);
        }
        return summary;
    }

    private static void summarizeJob(Job job, TestResultSummary summary, boolean hideZeroTestProjects) {
        AbstractTestResultAction tra;
        boolean addBlank = true;
        TestResultProjectAction testResults = (TestResultProjectAction)job.getAction(TestResultProjectAction.class);
        if (testResults != null && (tra = testResults.getLastTestResultAction()) != null) {
            addBlank = false;
            if (tra.getTotalCount() > 0 || !hideZeroTestProjects) {
                summary.addTestResult(new TestResult(job, tra.getTotalCount(), tra.getFailCount(), tra.getSkipCount()));
            }
        }
        if (addBlank && !hideZeroTestProjects) {
            summary.addTestResult(new TestResult(job, 0, 0, 0));
        }
    }

    public static TestResult getTestResult(Run run) {
        AbstractTestResultAction tra = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
        if (tra != null) {
            return new TestResult(run.getParent(), tra.getTotalCount(), tra.getFailCount(), tra.getSkipCount());
        }
        return new TestResult(run.getParent(), 0, 0, 0);
    }
}

