/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard;

import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ModelObject;
import hudson.model.TopLevelItem;
import hudson.plugins.view.dashboard.Dashboard;
import java.util.Comparator;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public abstract class DashboardPortlet
implements ModelObject,
Describable<DashboardPortlet>,
ExtensionPoint {
    private String name;

    public DashboardPortlet(String name) {
        this.name = name;
    }

    public String getId() {
        return "portlet-" + this.getDashboard().getPortletUrl(this).replace('/', '-');
    }

    public String getName() {
        return this.name;
    }

    public Dashboard getDashboard() {
        StaplerRequest req = Stapler.getCurrentRequest();
        return (Dashboard)((Object)req.findAncestorObject(Dashboard.class));
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getUrl() {
        return this.getDashboard().getPortletUrl(this) + '/';
    }

    public TopLevelItem getJob(String name) {
        return this.getDashboard().getJob(name);
    }

    public Descriptor<DashboardPortlet> getDescriptor() {
        return Jenkins.getActiveInstance().getDescriptor(this.getClass());
    }

    public static DescriptorExtensionList<DashboardPortlet, Descriptor<DashboardPortlet>> all() {
        return Jenkins.getActiveInstance().getDescriptorList(DashboardPortlet.class);
    }

    public static Comparator getComparator() {
        return new Comparator<Dashboard>(){

            @Override
            public int compare(Dashboard p1, Dashboard p2) {
                return p1.getDescription().compareTo(p2.getDescription());
            }
        };
    }
}

