/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.scm.CVSSCM;
import hudson.scm.CvsAuthentication;
import hudson.scm.CvsChangeSet;
import hudson.scm.CvsLog;
import hudson.scm.CvsRepositoryLocation;
import hudson.scm.CvsTagsParamValue;
import hudson.scm.cvs.Messages;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.log.RlogCommand;
import org.netbeans.lib.cvsclient.commandLine.BasicListener;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.ConnectionFactory;
import org.netbeans.lib.cvsclient.connection.ConnectionIdentity;
import org.netbeans.lib.cvsclient.event.CVSListener;

public class CvsTagsParamDefinition
extends ParameterDefinition {
    private static final Logger logger = Logger.getLogger("CvsTagsParamDefinition");
    private final String cvsRoot;
    private final Secret password;
    private final String moduleName;
    private final boolean passwordRequired;

    @DataBoundConstructor
    public CvsTagsParamDefinition(String name, String cvsRoot, boolean passwordRequired, String password, String moduleName) {
        super(name);
        this.cvsRoot = cvsRoot;
        this.password = Secret.fromString((String)password);
        this.moduleName = moduleName;
        this.passwordRequired = passwordRequired;
    }

    @Exported
    public String getCvsRoot() {
        return this.cvsRoot;
    }

    @Exported
    public Secret getPassword() {
        return this.password;
    }

    @Exported
    public String getModuleName() {
        return this.moduleName;
    }

    @Exported
    public boolean isPasswordRequired() {
        return this.passwordRequired;
    }

    public ParameterValue createValue(StaplerRequest req) {
        String[] values = req.getParameterValues(this.getName());
        if (values == null || values.length != 1) {
            return new CvsTagsParamValue(this.getName(), "HEAD");
        }
        return new CvsTagsParamValue(this.getName(), values[0]);
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject formData) {
        return (ParameterValue)req.bindJSON(CvsTagsParamValue.class, formData);
    }

    @Exported
    public ListBoxModel getSymbolicNames() {
        ListBoxModel model = new ListBoxModel();
        CvsChangeSet changeSet = null;
        RlogCommand statusCommand = new RlogCommand();
        statusCommand.setHeaderOnly(true);
        statusCommand.setModule(this.moduleName);
        statusCommand.setRecursive(true);
        try {
            final File tempRlogSpill = File.createTempFile("cvs", "status");
            final DeferredFileOutputStream outputStream = new DeferredFileOutputStream(102400, tempRlogSpill);
            PrintStream logStream = new PrintStream((OutputStream)outputStream, true, CVSSCM.DescriptorImpl.getOrDie().getChangelogEncoding());
            OutputStream errorOutputStream = new OutputStream(){
                final StringBuffer buffer = new StringBuffer();

                @Override
                public void write(int b) throws IOException {
                    if ("\n".getBytes()[0] == b) {
                        this.flush();
                    } else {
                        this.buffer.append(new String(new byte[]{(byte)b}));
                    }
                }

                @Override
                public void flush() throws IOException {
                    logger.info(this.buffer.toString());
                    this.buffer.delete(0, this.buffer.length());
                    super.flush();
                }

                @Override
                public void close() throws IOException {
                    this.flush();
                    super.close();
                }
            };
            PrintStream errorPrintStream = new PrintStream(errorOutputStream);
            Client cvsClient = this.getCvsClient(this.cvsRoot, this.passwordRequired, this.password);
            cvsClient.getEventManager().addCVSListener((CVSListener)new BasicListener(logStream, errorPrintStream));
            cvsClient.executeCommand((Command)statusCommand, this.getGlobalOptions(this.cvsRoot));
            logStream.close();
            errorPrintStream.flush();
            errorPrintStream.close();
            CvsLog parser = new CvsLog(){

                @Override
                public Reader read() throws IOException {
                    String changelogEncoding = CVSSCM.DescriptorImpl.getOrDie().getChangelogEncoding();
                    if (outputStream.isInMemory()) {
                        return new InputStreamReader((InputStream)new ByteArrayInputStream(outputStream.getData()), changelogEncoding);
                    }
                    return new InputStreamReader((InputStream)new FileInputStream(outputStream.getFile()), changelogEncoding);
                }

                @Override
                public void dispose() {
                    tempRlogSpill.delete();
                }
            };
            changeSet = parser.mapCvsLog(this.cvsRoot, new CvsRepositoryLocation.HeadRepositoryLocation(), null, new EnvVars());
        }
        catch (IOException ex) {
            model.add((Object)new ListBoxModel.Option("Could not load symbolic names due to an IO Error - " + ex.getLocalizedMessage()));
            return model;
        }
        catch (CommandAbortedException ex) {
            model.add((Object)new ListBoxModel.Option("Could not load symbolic names as the command was aborted - " + ex.getLocalizedMessage()));
            return model;
        }
        catch (CommandException ex) {
            model.add((Object)new ListBoxModel.Option("Could not load symbolic names due to a CVS command failure- " + ex.getLocalizedMessage()));
            return model;
        }
        catch (AuthenticationException ex) {
            model.add((Object)new ListBoxModel.Option("Could not load symbolic names due to an authentication failure - " + ex.getLocalizedMessage()));
            return model;
        }
        model.add((Object)new ListBoxModel.Option("Head", "HEAD"));
        for (String branchName : changeSet.getBranchNames()) {
            model.add((Object)new ListBoxModel.Option(branchName + " (Branch)", branchName));
        }
        for (String tagName : changeSet.getTagNames()) {
            model.add((Object)new ListBoxModel.Option(tagName + " (Tag)", tagName));
        }
        return model;
    }

    public Client getCvsClient(String cvsRootString, boolean passwordRequired, Secret password) {
        CVSRoot cvsRoot = CVSRoot.parse((String)cvsRootString);
        EnvVars envVars = new EnvVars(System.getenv());
        CVSSCM.DescriptorImpl cvsDescriptor = CVSSCM.DescriptorImpl.getOrDie();
        if (passwordRequired) {
            cvsRoot.setPassword(Secret.toString((Secret)password));
        } else {
            String partialRoot = cvsRoot.getHostName() + ":" + cvsRoot.getPort() + cvsRoot.getRepository();
            String sanitisedRoot = ":" + cvsRoot.getMethod() + ":" + partialRoot;
            for (CvsAuthentication authentication : cvsDescriptor.getAuthentication()) {
                if (!authentication.getCvsRoot().equals(sanitisedRoot) || cvsRoot.getUserName() != null && !authentication.getUsername().equals(cvsRoot.getUserName())) continue;
                cvsRoot = CVSRoot.parse((String)(":" + cvsRoot.getMethod() + ":" + (authentication.getUsername() != null ? authentication.getUsername() + "@" : "") + partialRoot));
                cvsRoot.setPassword(authentication.getPassword().getPlainText());
                break;
            }
        }
        ConnectionIdentity connectionIdentity = ConnectionFactory.getConnectionIdentity();
        connectionIdentity.setKnownHostsFile(envVars.expand(cvsDescriptor.getKnownHostsLocation()));
        connectionIdentity.setPrivateKeyPath(envVars.expand(cvsDescriptor.getPrivateKeyLocation()));
        if (cvsDescriptor.getPrivateKeyPassword() != null) {
            connectionIdentity.setPrivateKeyPassword(cvsDescriptor.getPrivateKeyPassword().getPlainText());
        }
        Connection cvsConnection = ConnectionFactory.getConnection((CVSRoot)cvsRoot);
        return new Client(cvsConnection, (AdminHandler)new StandardAdminHandler());
    }

    private GlobalOptions getGlobalOptions(String cvsRoot) {
        GlobalOptions globalOptions = new GlobalOptions();
        globalOptions.setVeryQuiet(true);
        globalOptions.setCVSRoot(cvsRoot);
        return globalOptions;
    }

    @Extension
    public static class ListCvsTagsParameterDefinitionDescriptor
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "CVS Symbolic Name Parameter";
        }

        public String getHelpFile() {
            return super.getHelpFile("CvsTagsParam");
        }

        public FormValidation doCheckCvsRoot(@QueryParameter String value) throws IOException {
            String v = Util.fixEmpty((String)value);
            if (v == null) {
                return FormValidation.error((String)Messages.CVSSCM_MissingCvsroot());
            }
            try {
                CVSRoot.parse((String)v);
            }
            catch (IllegalArgumentException ex) {
                return FormValidation.error((String)Messages.CVSSCM_InvalidCvsroot());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckModuleName(@QueryParameter String value) throws IOException {
            if (null == Util.fixEmpty((String)value)) {
                return FormValidation.error((String)Messages.CVSSCM_MissingModuleName());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckName(@QueryParameter String value) throws IOException {
            if (null == Util.fixEmpty((String)value)) {
                return FormValidation.error((String)Messages.CVSSCM_MissingParameterName());
            }
            return FormValidation.ok();
        }
    }
}

