/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.AbstractCvs;
import hudson.scm.AbstractCvsDescriptor;
import hudson.scm.CVSRepositoryBrowser;
import hudson.scm.CVSSCM;
import hudson.scm.CvsAuthentication;
import hudson.scm.CvsModule;
import hudson.scm.CvsRepository;
import hudson.scm.CvsRepositoryItem;
import hudson.scm.CvsRepositoryLocation;
import hudson.scm.ExcludedRegion;
import hudson.scm.PollingResult;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCMRevisionState;
import hudson.scm.cvs.Messages;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

public class CvsProjectset
extends AbstractCvs {
    private static final Pattern PSF_PATTERN = Pattern.compile("<project reference=\"[^,]+,((:[a-z]+:)([a-z|A-Z|0-9|\\.\\-]+)(:([0-9]+)?)?([/|a-z|A-Z|_|0-9|\\-]+)),([/|A-Z|a-z|0-9|_|\\.|\\-]+),([A-Z|a-z|0-9|_|\\.|\\-|/]+)(,(.*?)){0,1}\"/>");
    private final CvsRepository[] repositories;
    private final boolean canUseUpdate;
    private final String username;
    private final Secret password;
    private final CVSRepositoryBrowser browser;
    private final boolean skipChangeLog;
    private final boolean pruneEmptyDirectories;
    private final boolean disableCvsQuiet;
    private final boolean cleanOnFailedUpdate;
    private final boolean forceCleanCopy;

    @DataBoundConstructor
    public CvsProjectset(CvsRepository[] repositories, boolean canUseUpdate, String username, String password, CVSRepositoryBrowser browser, boolean skipChangeLog, boolean pruneEmptyDirectories, boolean disableCvsQuiet, boolean cleanOnFailedUpdate, boolean forceCleanCopy) {
        this.repositories = repositories;
        this.username = Util.fixEmpty((String)username);
        this.password = Secret.fromString((String)password);
        this.canUseUpdate = canUseUpdate;
        this.browser = browser;
        this.skipChangeLog = skipChangeLog;
        this.pruneEmptyDirectories = pruneEmptyDirectories;
        this.disableCvsQuiet = disableCvsQuiet;
        this.cleanOnFailedUpdate = cleanOnFailedUpdate;
        this.forceCleanCopy = forceCleanCopy;
    }

    @Override
    @Exported
    public CvsRepository[] getRepositories() {
        return this.repositories;
    }

    @Exported
    public String getUsername() {
        return this.username;
    }

    @Exported
    public Secret getPassword() {
        return this.password;
    }

    @Override
    @Exported
    public boolean isCanUseUpdate() {
        return this.canUseUpdate;
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        return super.compareRemoteRevisionWith(project, launcher, workspace, listener, baseline, this.getAllRepositories(workspace));
    }

    public boolean checkout(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        try {
            this.checkout((Run<?, ?>)build, launcher, workspace, (TaskListener)listener, changelogFile, null);
        }
        catch (AbortException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkout(@Nonnull Run<?, ?> build, @Nonnull Launcher launcher, @Nonnull FilePath workspace, @Nonnull TaskListener listener, @CheckForNull File changelogFile, @CheckForNull SCMRevisionState baseline) throws IOException, InterruptedException {
        String dateStamp;
        if (!this.isCanUseUpdate()) {
            workspace.deleteContents();
        }
        DateFormat dateFormat = DATE_FORMATTER;
        synchronized (dateFormat) {
            dateStamp = DATE_FORMATTER.format(this.getCheckoutDate(build));
        }
        if (!this.checkout(this.getRepositories(), false, workspace, this.isCanUseUpdate(), build, dateStamp, this.isPruneEmptyDirectories(), this.isCleanOnFailedUpdate(), listener)) {
            throw new AbortException();
        }
        if (!this.checkout(this.getInnerRepositories(workspace), false, workspace, this.isCanUseUpdate(), build, dateStamp, this.isPruneEmptyDirectories(), this.isCleanOnFailedUpdate(), listener)) {
            throw new AbortException();
        }
        this.postCheckout(build, changelogFile, this.getAllRepositories(workspace), workspace, listener, this.isFlatten(), build.getEnvironment(listener));
    }

    private CvsRepository[] getInnerRepositories(FilePath workspace) throws IOException, InterruptedException {
        ArrayList<CvsRepository> psfList = new ArrayList<CvsRepository>();
        for (CvsRepository repository : this.getRepositories()) {
            for (CvsRepositoryItem item : repository.getRepositoryItems()) {
                for (CvsModule module : item.getModules()) {
                    FilePath projectsetFile = workspace.child(module.getCheckoutName()).child(module.getProjectsetFileName());
                    if (!projectsetFile.exists()) {
                        throw new Error(Messages.CVSSCM_InvalidProjectset(module.getProjectsetFileName(), module.getRemoteName()));
                    }
                    String psfContents = projectsetFile.readToString();
                    Matcher matcher = PSF_PATTERN.matcher(psfContents);
                    while (matcher.find()) {
                        CvsModule innerModule = new CvsModule(matcher.group(7), matcher.group(8));
                        CvsRepositoryLocation innerLocation = matcher.group(10) == null ? new CvsRepositoryLocation.HeadRepositoryLocation() : new CvsRepositoryLocation.BranchRepositoryLocation(matcher.group(10), false);
                        CvsRepositoryItem innerItem = new CvsRepositoryItem(innerLocation, new CvsModule[]{innerModule});
                        CvsAuthentication authentication = this.getAuthenticationForCvsRoot(matcher.group(1));
                        StringBuilder root = new StringBuilder();
                        root.append(matcher.group(2));
                        String password = null;
                        if (authentication == null) {
                            Secret secret;
                            if (this.username != null) {
                                root.append(this.getUsername());
                                root.append("@");
                            }
                            if (null != (secret = this.getPassword())) {
                                password = secret.getPlainText();
                            }
                        }
                        root.append(matcher.group(3));
                        if (matcher.group(5) != null) {
                            root.append(":").append(matcher.group(5));
                        }
                        root.append(matcher.group(6));
                        CvsRepository innerRepository = new CvsRepository(root.toString(), password != null, password, Arrays.asList(innerItem), new ArrayList<ExcludedRegion>(), 0, null);
                        psfList.add(innerRepository);
                    }
                }
            }
        }
        return psfList.toArray(new CvsRepository[psfList.size()]);
    }

    private CvsAuthentication getAuthenticationForCvsRoot(String cvsRoot) {
        for (CvsAuthentication authentication : this.getDescriptor().getAuthentication()) {
            if (!authentication.getCvsRoot().equals(cvsRoot)) continue;
            return authentication;
        }
        return null;
    }

    private CvsRepository[] getAllRepositories(FilePath workspace) throws IOException, InterruptedException {
        ArrayList<CvsRepository> returnList = new ArrayList<CvsRepository>();
        returnList.addAll(Arrays.asList(this.getRepositories()));
        returnList.addAll(Arrays.asList(this.getInnerRepositories(workspace)));
        return returnList.toArray(new CvsRepository[returnList.size()]);
    }

    public boolean requiresWorkspaceForPolling() {
        return true;
    }

    @Override
    @Exported
    public boolean isPruneEmptyDirectories() {
        return this.pruneEmptyDirectories;
    }

    @Override
    @Exported
    public boolean isCleanOnFailedUpdate() {
        return this.cleanOnFailedUpdate;
    }

    @Override
    @Exported
    public boolean isDisableCvsQuiet() {
        return this.disableCvsQuiet;
    }

    @Override
    @Exported
    public boolean isSkipChangeLog() {
        return this.skipChangeLog;
    }

    @Override
    @Exported
    public boolean isForceCleanCopy() {
        return this.forceCleanCopy;
    }

    @Override
    public boolean isFlatten() {
        return false;
    }

    public RepositoryBrowser getBrowser() {
        return this.browser;
    }

    @Override
    public CvsProjectsetDescriptor getDescriptor() {
        return (CvsProjectsetDescriptor)super.getDescriptor();
    }

    @Extension
    public static class CvsProjectsetDescriptor
    extends AbstractCvsDescriptor<CvsProjectset> {
        public CvsProjectsetDescriptor() {
            super(CVSRepositoryBrowser.class);
        }

        public String getDisplayName() {
            return "CVS Projectset";
        }

        @Override
        public String getKnownHostsLocation() {
            return CVSSCM.DescriptorImpl.getOrDie().getKnownHostsLocation();
        }

        @Override
        public String getPrivateKeyLocation() {
            return CVSSCM.DescriptorImpl.getOrDie().getPrivateKeyLocation();
        }

        @Override
        public Secret getPrivateKeyPassword() {
            return CVSSCM.DescriptorImpl.getOrDie().getPrivateKeyPassword();
        }

        @Override
        public int getCompressionLevel() {
            return CVSSCM.DescriptorImpl.getOrDie().getCompressionLevel();
        }

        @Override
        public CvsAuthentication[] getAuthentication() {
            return CVSSCM.DescriptorImpl.getOrDie().getAuthentication();
        }

        @Override
        public String getChangelogEncoding() {
            return CVSSCM.DescriptorImpl.getOrDie().getChangelogEncoding();
        }
    }
}

