/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jobicon;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import jenkins.plugins.jobicon.CustomIconAction;
import jenkins.plugins.jobicon.ImageUtils;
import jenkins.plugins.jobicon.Messages;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.fileupload.FileItem;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.lang.Klass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomIconProperty
extends JobProperty<Job<?, ?>> {
    public static final String PATH = "customIcon";
    public final String iconfile;

    @DataBoundConstructor
    public CustomIconProperty(String iconfile) {
        this.iconfile = iconfile;
    }

    public Collection<CustomIconAction> getJobActions(Job job) {
        return Arrays.asList(new CustomIconAction(job));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return "Custom icon";
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }

        public CustomIconProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (formData.has("jobicon")) {
                if (!formData.getJSONObject("jobicon").has("iconfile")) {
                    throw new Descriptor.FormException(Messages.Config_missing(), "iconfile");
                }
                return (CustomIconProperty)((Object)req.bindJSON(CustomIconProperty.class, formData.getJSONObject("jobicon")));
            }
            return null;
        }

        public void doStartUpload(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            rsp.setContentType("text/html");
            req.getView(CustomIconProperty.class, "startUpload.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
        }

        public void doGlobalIconsTable(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            rsp.setContentType("text/html");
            ((RequestImpl)req).getView(Klass.java(CustomIconProperty.class), (Object)this, "global-icons-table.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
        }

        public void doDeleteIcon(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
            this.deleteIcon(req.getParameter("icon"));
            this.doGlobalIconsTable(req, rsp);
        }

        public void doUpload(StaplerRequest req, StaplerResponse rsp, @QueryParameter String job) throws IOException, ServletException, InterruptedException, NoSuchAlgorithmException {
            Jenkins jenkins = Jenkins.getInstance();
            jenkins.checkPermission(Jenkins.ADMINISTER);
            FileItem file = req.getFileItem("jobicon.file");
            String error = null;
            if (file == null || file.getName().isEmpty()) {
                error = Messages.Upload_noFile();
            } else {
                MessageDigest dg = MessageDigest.getInstance("SHA1");
                String filename = Hex.encodeHexString((byte[])dg.digest(file.get())) + ".png";
                FilePath iconDir = jenkins.getRootPath().child("userContent").child(CustomIconProperty.PATH);
                iconDir.mkdirs();
                FilePath icon = iconDir.child(filename);
                if (icon.exists()) {
                    error = Messages.Upload_dup();
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ImageUtils.resize(file.getInputStream(), out, 64);
                icon.copyFrom((InputStream)new ByteArrayInputStream(out.toByteArray()));
                icon.chmod(420);
            }
            rsp.setContentType("text/html");
            rsp.getWriter().println((error != null ? error : Messages.Upload_done()) + " <a href=\"javascript:history.back()\">" + Messages.Upload_back() + "</a>");
        }

        public List<String> getIcons() throws IOException, InterruptedException {
            FilePath iconDir = Jenkins.getInstance().getRootPath().child("userContent").child(CustomIconProperty.PATH);
            if (!iconDir.exists()) {
                return Collections.EMPTY_LIST;
            }
            List files = iconDir.list();
            ArrayList<String> names = new ArrayList<String>();
            for (FilePath fp : files) {
                names.add(fp.getBaseName());
            }
            Collections.sort(names);
            return names;
        }

        private void deleteIcon(String id) throws IOException, InterruptedException {
            FilePath iconFile = Jenkins.getInstance().getRootPath().child("userContent").child(CustomIconProperty.PATH).child(id + ".png");
            if (iconFile.exists()) {
                iconFile.delete();
            }
        }

        public boolean isIconListEmpty() throws IOException, InterruptedException {
            return this.getIcons().isEmpty();
        }

        public List<List<String>> getIconsAsListOfList(int colCount) throws IOException, InterruptedException {
            List<String> icons = this.getIcons();
            ArrayList<List<String>> split = new ArrayList<List<String>>();
            ArrayList<String> tmp = null;
            for (int i = 0; i < icons.size(); ++i) {
                if (i % colCount == 0) {
                    tmp = new ArrayList<String>();
                    split.add(tmp);
                }
                tmp.add(icons.get(i));
            }
            return split;
        }
    }
}

