/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jobicon;

import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Job;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.plugins.jobicon.CustomIconProperty;
import jenkins.plugins.jobicon.ImageUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class CustomIconAction
implements Action {
    private final Job job;
    private final Map<Integer, byte[]> cache;

    public CustomIconAction(Job job) {
        this.job = job;
        this.cache = new HashMap<Integer, byte[]>();
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "Custom Icon";
    }

    public String getUrlName() {
        return "customIcon";
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
        CustomIconProperty prop = (CustomIconProperty)this.job.getProperty(CustomIconProperty.class);
        FilePath fpath = Jenkins.getInstance().getRootPath().child("userContent").child("customIcon").child(prop.iconfile);
        URL url = fpath.toURI().toURL();
        String size = req.getParameter("size");
        InputStream in = "16x16".equals(size) ? new ByteArrayInputStream(this.resize(url, 16)) : ("24x24".equals(size) ? new ByteArrayInputStream(this.resize(url, 24)) : ("32x32".equals(size) ? new ByteArrayInputStream(this.resize(url, 32)) : url.openStream()));
        rsp.serveFile(req, in, 0L, 0L, -1, fpath.getName());
    }

    private byte[] resize(URL url, int size) throws IOException {
        if (this.cache.get(size) != null) {
            return this.cache.get(size);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageUtils.resize(url.openStream(), out, size);
        this.cache.put(size, out.toByteArray());
        return out.toByteArray();
    }
}

