/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.ContextMenuIconUtils;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.Messages;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.model.RootAction;
import hudson.model.TopLevelItem;
import hudson.model.TransientUserActionFactory;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.model.ModelObjectWithContextMenu;
import jenkins.model.TransientActionFactory;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class ViewCredentialsAction
implements Action,
IconSpec,
AccessControlled,
ModelObjectWithContextMenu {
    public static final Permission VIEW = CredentialsProvider.VIEW;
    @Restricted(value={NoExternalUse.class})
    public static final Permission MANAGE_DOMAINS = CredentialsProvider.MANAGE_DOMAINS;
    private final ModelObject context;

    public ViewCredentialsAction(ModelObject context) {
        this.context = context;
    }

    public ModelObject getContext() {
        return this.context;
    }

    public String getIconFileName() {
        return this.isVisible() ? "/plugin/credentials/images/24x24/credentials.png" : null;
    }

    @NonNull
    public List<CredentialsStore> getParentStores() {
        ArrayList<CredentialsStore> result = new ArrayList<CredentialsStore>();
        for (CredentialsStore s : CredentialsProvider.lookupStores(this.getContext())) {
            if (this.context == s.getContext() || !s.hasPermission(CredentialsProvider.VIEW)) continue;
            result.add(s);
        }
        return result;
    }

    @NonNull
    public List<CredentialsStore> getLocalStores() {
        ArrayList<CredentialsStore> result = new ArrayList<CredentialsStore>();
        for (CredentialsStore s : CredentialsProvider.lookupStores(this.getContext())) {
            if (this.context != s.getContext() || !s.hasPermission(CredentialsProvider.VIEW)) continue;
            result.add(s);
        }
        return result;
    }

    @NonNull
    public List<CredentialsStoreAction> getStoreActions() {
        ArrayList<CredentialsStoreAction> result = new ArrayList<CredentialsStoreAction>();
        for (CredentialsStore s : CredentialsProvider.lookupStores(this.getContext())) {
            CredentialsStoreAction action;
            if (this.context != s.getContext() || !s.hasPermission(CredentialsProvider.VIEW) || (action = s.getStoreAction()) == null) continue;
            result.add(action);
        }
        return result;
    }

    @Exported(name="stores")
    @NonNull
    public Map<String, CredentialsStoreAction> getStoreActionsMap() {
        TreeMap<String, CredentialsStoreAction> result = new TreeMap<String, CredentialsStoreAction>();
        for (CredentialsStoreAction a : this.getStoreActions()) {
            result.put(a.getUrlName(), a);
        }
        return result;
    }

    @CheckForNull
    public CredentialsStoreAction getStore(String name) {
        for (CredentialsStore s : CredentialsProvider.lookupStores(this.getContext())) {
            CredentialsStoreAction action;
            if (this.context != s.getContext() || (action = s.getStoreAction()) == null || !name.equals(action.getUrlName())) continue;
            return s.hasPermission(CredentialsProvider.VIEW) ? action : null;
        }
        return null;
    }

    public String getDisplayName() {
        return Messages.CredentialsStoreAction_DisplayName();
    }

    public String getUrlName() {
        return "credentials";
    }

    public String getStoreBaseUrl(String itUrl) {
        return itUrl.isEmpty() || itUrl.endsWith("/") ? itUrl + this.getUrlName() + "/store/" : itUrl + "/" + this.getUrlName() + "/store/";
    }

    public boolean isVisible() {
        if (this.context instanceof AccessControlled && !((AccessControlled)this.context).hasPermission(CredentialsProvider.VIEW)) {
            return false;
        }
        for (CredentialsProvider p : CredentialsProvider.enabled(this.context)) {
            if (!p.hasCredentialsDescriptors()) continue;
            return true;
        }
        return false;
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    public List<TableEntry> getTableEntries() {
        ArrayList<TableEntry> result = new ArrayList<TableEntry>();
        HashSet<String> ids = new HashSet<String>();
        for (CredentialsStore p : CredentialsProvider.lookupStores(this.context)) {
            if (!p.hasPermission(CredentialsProvider.VIEW)) continue;
            for (Domain domain : p.getDomains()) {
                for (Credentials c : p.getCredentials(domain)) {
                    boolean masked;
                    CredentialsScope scope = c.getScope();
                    if (scope != null && !scope.isVisible(this.context)) continue;
                    if (c instanceof IdCredentials) {
                        String id = ((IdCredentials)c).getId();
                        masked = ids.contains(id);
                        ids.add(id);
                    } else {
                        masked = false;
                    }
                    result.add(new TableEntry(p.getProvider(), p, domain, c, masked));
                }
            }
        }
        return result;
    }

    public String getIconClassName() {
        return this.isVisible() ? "icon-credentials-credentials" : null;
    }

    public final String getFullName() {
        String n = this.getContextFullName();
        if (n.length() == 0) {
            return this.getUrlName();
        }
        return n + '/' + this.getUrlName();
    }

    public String getContextFullName() {
        String n = this.context instanceof Item ? ((Item)this.context).getFullName() : (this.context instanceof ItemGroup ? ((ItemGroup)this.context).getFullName() : (this.context instanceof User ? "user/" + ((User)this.context).getId() : ""));
        return n;
    }

    public final String getFullDisplayName() {
        String n = this.getContextFullDisplayName();
        if (n.length() == 0) {
            return this.getDisplayName();
        }
        return n + " \u00bb " + this.getDisplayName();
    }

    public String getContextFullDisplayName() {
        String n = this.context instanceof Item ? ((Item)this.context).getFullDisplayName() : (this.context instanceof Jenkins ? this.context.getDisplayName() : (this.context instanceof ItemGroup ? ((ItemGroup)this.context).getFullDisplayName() : (this.context instanceof User ? Messages.CredentialsStoreAction_UserDisplayName(((User)this.context).getDisplayName()) : Jenkins.get().getFullDisplayName())));
        return n;
    }

    @Nonnull
    public ACL getACL() {
        Jenkins accessControlled = this.context instanceof AccessControlled ? (AccessControlled)this.context : Jenkins.get();
        return new ACL((AccessControlled)accessControlled){
            final /* synthetic */ AccessControlled val$accessControlled;
            {
                this.val$accessControlled = accessControlled;
            }

            public boolean hasPermission(@Nonnull Authentication a, @Nonnull Permission permission) {
                if (this.val$accessControlled.getACL().hasPermission(a, permission)) {
                    for (CredentialsStore s : ViewCredentialsAction.this.getLocalStores()) {
                        if (!s.hasPermission(a, permission)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public void checkPermission(@Nonnull Permission permission) throws AccessDeniedException {
        this.getACL().checkPermission(permission);
    }

    public boolean hasPermission(@Nonnull Permission permission) {
        return this.getACL().hasPermission(permission);
    }

    public ModelObjectWithContextMenu.ContextMenu doContextMenu(StaplerRequest request, StaplerResponse response) throws Exception {
        ModelObjectWithContextMenu.ContextMenu menu = new ModelObjectWithContextMenu.ContextMenu();
        for (CredentialsStoreAction action : this.getStoreActions()) {
            ContextMenuIconUtils.addMenuItem(menu, "store", action, action.getContextMenu(ContextMenuIconUtils.buildUrl("store", action.getUrlName())));
        }
        return menu;
    }

    public static class TableEntry
    implements IconSpec {
        private final Credentials credentials;
        private final CredentialsProvider provider;
        private final CredentialsStore store;
        private final Domain domain;
        private final boolean masked;

        public TableEntry(CredentialsProvider provider, CredentialsStore store, Domain domain, Credentials credentials, boolean masked) {
            this.provider = provider;
            this.store = store;
            this.domain = domain;
            this.credentials = credentials;
            this.masked = masked;
        }

        public String getId() {
            return this.credentials instanceof IdCredentials ? ((IdCredentials)this.credentials).getId() : null;
        }

        public CredentialsScope getScope() {
            return this.credentials.getScope();
        }

        public String getName() {
            return CredentialsNameProvider.name(this.credentials);
        }

        public String getDescription() throws IOException {
            return this.credentials instanceof StandardCredentials ? Jenkins.get().getMarkupFormatter().translate(((StandardCredentials)this.credentials).getDescription()) : null;
        }

        public String getKind() {
            return this.credentials.getDescriptor().getDisplayName();
        }

        public CredentialsProvider getProvider() {
            return this.provider;
        }

        public Domain getDomain() {
            return this.domain;
        }

        public CredentialsStore getStore() {
            return this.store;
        }

        public String getIconClassName() {
            return this.credentials.getDescriptor().getIconClassName();
        }

        public boolean isMasked() {
            return this.masked;
        }
    }

    @Extension(ordinal=-1000.0)
    public static class RootActionImpl
    extends ViewCredentialsAction
    implements RootAction {
        public RootActionImpl() {
            super((ModelObject)Jenkins.get());
        }
    }

    @Extension(ordinal=-1000.0)
    public static class TransientUserActionFactoryImpl
    extends TransientUserActionFactory {
        public Collection<? extends Action> createFor(User target) {
            return Collections.singleton(new ViewCredentialsAction((ModelObject)target));
        }
    }

    @Extension(ordinal=-1000.0)
    public static class TransientTopLevelItemActionFactoryImpl
    extends TransientActionFactory<TopLevelItem> {
        public Class<TopLevelItem> type() {
            return TopLevelItem.class;
        }

        @Nonnull
        public Collection<? extends Action> createFor(@Nonnull TopLevelItem target) {
            return Collections.singleton(new ViewCredentialsAction((ModelObject)target));
        }
    }
}

