/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.cli;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.cli.BaseCredentialsCLICommand;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainCredentials;
import hudson.Extension;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.Argument;

@Extension
public class ListCredentialsAsXmlCommand
extends BaseCredentialsCLICommand {
    @Argument(metaVar="STORE", usage="Store ID to export credentials from. For example the Jenkins credentials global store would be identified by \"system::system::jenkins\", and folder scoped credentials as \"folder::item::/full/name/of/folder\"", required=true)
    private CredentialsStore store;

    public String getShortDescription() {
        return "Export credentials as XML. The output of this command can be used as input for \"import-credentials-as-xml\" as is, the only needed change is to set the actual Secrets which are redacted in the output.";
    }

    protected int run() throws Exception {
        this.store.checkPermission(CredentialsProvider.UPDATE);
        ArrayList<DomainCredentials> existing = new ArrayList<DomainCredentials>();
        List<Domain> domains = this.store.getDomains();
        for (Domain domain : domains) {
            existing.add(new DomainCredentials(domain, this.store.getCredentials(domain)));
        }
        CredentialsStoreAction.SECRETS_REDACTED.toXML(existing, (Writer)new OutputStreamWriter((OutputStream)this.stdout, StandardCharsets.UTF_8));
        return 0;
    }
}

