/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.domains;

import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.HostnamePortRequirement;
import com.cloudbees.plugins.credentials.domains.HostnameRequirement;
import com.cloudbees.plugins.credentials.domains.PathRequirement;
import com.cloudbees.plugins.credentials.domains.SchemeRequirement;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class URIRequirementBuilder {
    @NonNull
    private final List<DomainRequirement> requirements;

    private URIRequirementBuilder(@NonNull List<DomainRequirement> requirements) {
        this.requirements = new ArrayList<DomainRequirement>(requirements);
    }

    @NonNull
    public static URIRequirementBuilder create() {
        return new URIRequirementBuilder(Collections.emptyList());
    }

    @NonNull
    public static URIRequirementBuilder fromUri(@CheckForNull String uri) {
        return URIRequirementBuilder.create().withUri(uri);
    }

    @NonNull
    public URIRequirementBuilder duplicate() {
        return new URIRequirementBuilder(this.requirements);
    }

    @NonNull
    public URIRequirementBuilder withUri(@CheckForNull String uri) {
        if (uri != null) {
            try {
                URI u = new URI(uri);
                this.withScheme(u.getScheme());
                this.withHostnamePort(u.getHost(), u.getPort());
                this.withPath(u.getRawPath());
            }
            catch (URISyntaxException e) {
                this.withoutScheme().withoutHostname().withoutHostnamePort();
            }
        }
        return this;
    }

    @NonNull
    public URIRequirementBuilder withoutScheme() {
        this.requirements.removeIf(r -> r instanceof SchemeRequirement);
        return this;
    }

    @NonNull
    public URIRequirementBuilder withoutPath() {
        this.requirements.removeIf(r -> r instanceof PathRequirement);
        return this;
    }

    @NonNull
    public URIRequirementBuilder withoutHostname() {
        this.requirements.removeIf(r -> r instanceof HostnameRequirement);
        return this;
    }

    @NonNull
    public URIRequirementBuilder withoutHostnamePort() {
        this.requirements.removeIf(r -> r instanceof HostnamePortRequirement);
        return this;
    }

    @NonNull
    public URIRequirementBuilder withScheme(@CheckForNull String scheme) {
        this.withoutScheme();
        if (scheme != null) {
            this.requirements.add(new SchemeRequirement(scheme));
        }
        return this;
    }

    @NonNull
    public URIRequirementBuilder withPath(@CheckForNull String path) {
        this.withoutPath();
        if (path != null) {
            this.requirements.add(new PathRequirement(path));
        }
        return this;
    }

    @NonNull
    public URIRequirementBuilder withHostname(@CheckForNull String hostname) {
        return this.withHostnamePort(hostname, -1);
    }

    @NonNull
    public URIRequirementBuilder withHostnamePort(@CheckForNull String hostname, int port) {
        this.withoutHostname();
        this.withoutHostnamePort();
        if (hostname != null) {
            this.requirements.add(new HostnameRequirement(hostname));
            if (port != -1) {
                this.requirements.add(new HostnamePortRequirement(hostname, port));
            }
        }
        return this;
    }

    @NonNull
    public List<DomainRequirement> build() {
        return new ArrayList<DomainRequirement>(this.requirements);
    }
}

