/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.AccessDeniedException2;
import hudson.security.Permission;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CredentialsStore
implements AccessControlled {
    private transient Boolean domainsModifiable;

    public abstract ModelObject getContext();

    public final void checkPermission(@NonNull Permission p) {
        Authentication a = Jenkins.getAuthentication();
        if (!this.hasPermission(a, p)) {
            throw new AccessDeniedException2(a, p);
        }
    }

    public final boolean hasPermission(@NonNull Permission p) {
        return this.hasPermission(Jenkins.getAuthentication(), p);
    }

    public abstract boolean hasPermission(@NonNull Authentication var1, @NonNull Permission var2);

    public ACL getACL() {
        return new ACL(){

            public boolean hasPermission(Authentication a, Permission permission) {
                return CredentialsStore.this.hasPermission(a, permission);
            }
        };
    }

    @NonNull
    public List<Domain> getDomains() {
        return Collections.singletonList(Domain.global());
    }

    public final boolean isDomainsModifiable() {
        if (this.domainsModifiable == null) {
            try {
                this.domainsModifiable = this.isOverridden("getDomains", new Class[0]) && this.isOverridden("addDomain", Domain.class, List.class) && this.isOverridden("removeDomain", Domain.class) && this.isOverridden("updateDomain", Domain.class, Domain.class);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        return this.domainsModifiable;
    }

    private boolean isOverridden(String name, Class ... args) throws NoSuchMethodException {
        return this.getClass().getMethod(name, args).getDeclaringClass() != CredentialsStore.class;
    }

    @NonNull
    public abstract List<Credentials> getCredentials(@NonNull Domain var1);

    public final boolean addDomain(@NonNull Domain domain, Credentials ... credentials) throws IOException {
        return this.addDomain(domain, Arrays.asList(credentials));
    }

    public boolean addDomain(@NonNull Domain domain, List<Credentials> credentials) throws IOException {
        throw new UnsupportedOperationException("Implementation does not support adding domains");
    }

    public boolean removeDomain(@NonNull Domain domain) throws IOException {
        throw new UnsupportedOperationException("Implementation does not support removing domains");
    }

    public boolean updateDomain(@NonNull Domain current, @NonNull Domain replacement) throws IOException {
        throw new UnsupportedOperationException("Implementation does not support updating domains");
    }

    public abstract boolean addCredentials(@NonNull Domain var1, @NonNull Credentials var2) throws IOException;

    public abstract boolean removeCredentials(@NonNull Domain var1, @NonNull Credentials var2) throws IOException;

    public abstract boolean updateCredentials(@NonNull Domain var1, @NonNull Credentials var2, @NonNull Credentials var3) throws IOException;
}

