/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.Messages;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.DomainSpecification;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.security.ACL;
import hudson.util.CopyOnWriteMap;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class UserCredentialsProvider
extends CredentialsProvider {
    private static final Logger LOGGER = Logger.getLogger(UserCredentialsProperty.class.getName());
    private static final Set<CredentialsScope> SCOPES = Collections.singleton(CredentialsScope.USER);

    @Override
    public Set<CredentialsScope> getScopes(ModelObject object) {
        if (object instanceof User) {
            return SCOPES;
        }
        return super.getScopes(object);
    }

    @Override
    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication) {
        return this.getCredentials(type, itemGroup, authentication, Collections.<DomainRequirement>emptyList());
    }

    @Override
    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        if (authentication == null) {
            authentication = ACL.SYSTEM;
        }
        if (!ACL.SYSTEM.equals(authentication)) {
            UserCredentialsProperty property;
            User user;
            try {
                user = authentication == null || authentication instanceof AnonymousAuthenticationToken ? null : (authentication == Jenkins.getAuthentication() ? User.current() : User.get((String)authentication.getName()));
            }
            catch (NullPointerException e) {
                LogRecord lr = new LogRecord(Level.FINE, "Could not find user for specified authentication. User credentials lookup aborted");
                lr.setThrown(e);
                lr.setParameters(new Object[]{authentication});
                LOGGER.log(lr);
                user = null;
            }
            if (user != null && (property = (UserCredentialsProperty)user.getProperty(UserCredentialsProperty.class)) != null) {
                return DomainCredentials.getCredentials(property.getDomainCredentialsMap(), type, domainRequirements, CredentialsMatchers.always());
            }
        }
        return new ArrayList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UserCredentialsProperty
    extends UserProperty {
        @Deprecated
        private transient List<Credentials> credentials;
        private Map<Domain, List<Credentials>> domainCredentialsMap = new CopyOnWriteMap.Hash();

        @Deprecated
        public UserCredentialsProperty(List<Credentials> credentials) {
            this.domainCredentialsMap = DomainCredentials.migrateListToMap(this.domainCredentialsMap, credentials);
        }

        @DataBoundConstructor
        public UserCredentialsProperty(DomainCredentials[] domainCredentials) {
            this.domainCredentialsMap = DomainCredentials.asMap(Arrays.asList(domainCredentials));
        }

        private Object readResolve() throws ObjectStreamException {
            if (this.domainCredentialsMap == null) {
                this.domainCredentialsMap = DomainCredentials.migrateListToMap(this.domainCredentialsMap, this.credentials);
                this.credentials = null;
            }
            return this;
        }

        public <C extends Credentials> List<C> getCredentials(Class<C> type) {
            ArrayList<C> result = new ArrayList<C>();
            for (Credentials credential : this.getCredentials()) {
                if (!type.isInstance(credential)) continue;
                result.add(type.cast(credential));
            }
            return result;
        }

        public List<Credentials> getCredentials() {
            return this.domainCredentialsMap.get(Domain.global());
        }

        public List<DomainCredentials> getDomainCredentials() {
            return DomainCredentials.asList(this.getDomainCredentialsMap());
        }

        @NonNull
        public synchronized Map<Domain, List<Credentials>> getDomainCredentialsMap() {
            this.domainCredentialsMap = DomainCredentials.migrateListToMap(this.domainCredentialsMap, this.credentials);
            return this.domainCredentialsMap;
        }

        public synchronized void setDomainCredentialsMap(Map<Domain, List<Credentials>> domainCredentialsMap) {
            this.domainCredentialsMap = DomainCredentials.toCopyOnWriteMap(domainCredentialsMap);
        }

        public UserProperty reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
            User selUser = (User)req.findAncestorObject(User.class);
            User curUser = User.current();
            if (selUser != null && curUser != null && selUser.getId().equals(curUser.getId())) {
                return (UserProperty)this.getDescriptor().newInstance(req, form);
            }
            return this;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @Extension
        public static class DescriptorImpl
        extends UserPropertyDescriptor {
            public UserProperty newInstance(User user) {
                return new UserCredentialsProperty(new DomainCredentials[0]);
            }

            public String getDisplayName() {
                return Messages.UserCredentialsProvider_DisplayName();
            }

            public boolean isVisible() {
                if (!this.isEnabled()) {
                    return false;
                }
                StaplerRequest req = Stapler.getCurrentRequest();
                if (req == null) {
                    return false;
                }
                User selUser = (User)req.findAncestorObject(User.class);
                User curUser = User.current();
                return selUser != null && curUser != null && selUser.equals(curUser);
            }

            public DescriptorExtensionList<Credentials, Descriptor<Credentials>> getCredentialDescriptors() {
                return CredentialsProvider.allCredentialsDescriptors();
            }

            public DescriptorExtensionList<DomainSpecification, Descriptor<DomainSpecification>> getSpecificationDescriptors() {
                return Jenkins.getInstance().getDescriptorList(DomainSpecification.class);
            }

            public boolean isEnabled() {
                return !UserProperty.all().isEmpty();
            }
        }
    }
}

