/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsResolver;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsSnapshotTaker;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.Messages;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.DescriptorExtensionList;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CredentialsProvider
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(CredentialsProvider.class.getName());
    public static final PermissionGroup GROUP = new PermissionGroup(CredentialsProvider.class, Messages._CredentialsProvider_PermissionGroupTitle());
    private static final PermissionScope[] SCOPES = new PermissionScope[]{PermissionScope.ITEM, PermissionScope.ITEM_GROUP, PermissionScope.JENKINS};
    public static final Permission CREATE = new Permission(GROUP, "Create", Messages._CredentialsProvider_CreatePermissionDescription(), Permission.CREATE, true, SCOPES);
    public static final Permission UPDATE = new Permission(GROUP, "Update", Messages._CredentialsProvider_UpdatePermissionDescription(), Permission.UPDATE, true, SCOPES);
    public static final Permission VIEW = new Permission(GROUP, "View", Messages._CredentialsProvider_ViewPermissionDescription(), Permission.READ, true, SCOPES);
    public static final Permission DELETE = new Permission(GROUP, "Delete", Messages._CredentialsProvider_DeletePermissionDescription(), Permission.DELETE, true, SCOPES);
    public static final Permission MANAGE_DOMAINS = new Permission(GROUP, "ManageDomains", Messages._CredentialsProvider_ManageDomainsPermissionDescription(), Permission.CONFIGURE, true, SCOPES);

    public static DescriptorExtensionList<Credentials, Descriptor<Credentials>> allCredentialsDescriptors() {
        return Hudson.getInstance().getDescriptorList(Credentials.class);
    }

    public Set<CredentialsScope> getScopes(ModelObject object) {
        return null;
    }

    @CheckForNull
    public CredentialsStore getStore(@CheckForNull ModelObject object) {
        return null;
    }

    @NonNull
    public abstract <C extends Credentials> List<C> getCredentials(@NonNull Class<C> var1, @Nullable ItemGroup var2, @Nullable Authentication var3);

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        return this.getCredentials(type, itemGroup, authentication);
    }

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @NonNull Item item, @Nullable Authentication authentication) {
        item.getClass();
        return this.getCredentials(type, item.getParent(), authentication);
    }

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @NonNull Item item, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        return this.getCredentials(type, item.getParent(), authentication, domainRequirements);
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type) {
        return CredentialsProvider.lookupCredentials(type, (Item)null, ACL.SYSTEM);
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Authentication authentication) {
        return CredentialsProvider.lookupCredentials(type, (ItemGroup)Hudson.getInstance(), authentication);
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Item item) {
        return item == null ? CredentialsProvider.lookupCredentials(type, (ItemGroup)Hudson.getInstance(), ACL.SYSTEM) : CredentialsProvider.lookupCredentials(type, item, ACL.SYSTEM);
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup) {
        return CredentialsProvider.lookupCredentials(type, itemGroup, ACL.SYSTEM);
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication) {
        return CredentialsProvider.lookupCredentials(type, itemGroup, authentication, Collections.<DomainRequirement>emptyList());
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Item item, @Nullable Authentication authentication) {
        return CredentialsProvider.lookupCredentials(type, item, authentication, Collections.<DomainRequirement>emptyList());
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, DomainRequirement ... domainRequirements) {
        return CredentialsProvider.lookupCredentials(type, itemGroup, authentication, Arrays.asList(domainRequirements));
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @Nullable List<DomainRequirement> domainRequirements) {
        ExtensionList providers;
        type.getClass();
        itemGroup = itemGroup == null ? Hudson.getInstance() : itemGroup;
        authentication = authentication == null ? ACL.SYSTEM : authentication;
        domainRequirements = domainRequirements == null ? Collections.emptyList() : domainRequirements;
        CredentialsResolver<Credentials, C> resolver = CredentialsResolver.getResolver(type);
        if (resolver != null) {
            LOGGER.log(Level.FINE, "Resolving legacy credentials of type {0} with resolver {1}", new Object[]{type, resolver});
            List<Credentials> originals = CredentialsProvider.lookupCredentials(resolver.getFromClass(), itemGroup, authentication, domainRequirements);
            LOGGER.log(Level.FINE, "Original credentials for resolving: {0}", originals);
            return resolver.resolve(originals);
        }
        try {
            providers = Hudson.getInstance().getExtensionList(CredentialsProvider.class);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not retrieve list of CredentialsProvider instances", e);
            return Collections.emptyList();
        }
        ArrayList<C> result = new ArrayList<C>();
        for (CredentialsProvider provider : providers) {
            try {
                result.addAll(provider.getCredentials(type, itemGroup, authentication, domainRequirements));
            }
            catch (NoClassDefFoundError e) {
                LOGGER.log(Level.FINE, "Could not retrieve provider credentials from " + provider + " likely due to missing optional dependency", e);
            }
        }
        return result;
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Item item, @Nullable Authentication authentication, DomainRequirement ... domainRequirements) {
        return CredentialsProvider.lookupCredentials(type, item, authentication, Arrays.asList(domainRequirements));
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Item item, @Nullable Authentication authentication, @Nullable List<DomainRequirement> domainRequirements) {
        ExtensionList providers;
        type.getClass();
        if (item == null) {
            return CredentialsProvider.lookupCredentials(type, (ItemGroup)Hudson.getInstance(), authentication);
        }
        authentication = authentication == null ? ACL.SYSTEM : authentication;
        domainRequirements = domainRequirements == null ? Collections.emptyList() : domainRequirements;
        CredentialsResolver<Credentials, C> resolver = CredentialsResolver.getResolver(type);
        if (resolver != null) {
            LOGGER.log(Level.FINE, "Resolving legacy credentials of type {0} with resolver {1}", new Object[]{type, resolver});
            List<Credentials> originals = CredentialsProvider.lookupCredentials(resolver.getFromClass(), item, authentication, domainRequirements);
            LOGGER.log(Level.FINE, "Original credentials for resolving: {0}", originals);
            return resolver.resolve(originals);
        }
        try {
            providers = Hudson.getInstance().getExtensionList(CredentialsProvider.class);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not retrieve list of CredentialsProvider instances", e);
            return Collections.emptyList();
        }
        ArrayList<C> result = new ArrayList<C>();
        for (CredentialsProvider provider : providers) {
            try {
                result.addAll(provider.getCredentials(type, item, authentication, domainRequirements));
            }
            catch (NoClassDefFoundError e) {
                LOGGER.log(Level.FINE, "Could not retrieve provider credentials from " + provider + " likely due to missing optional dependency", e);
            }
        }
        return result;
    }

    @CheckForNull
    public static Set<CredentialsScope> lookupScopes(ModelObject object) {
        ExtensionList providers;
        try {
            providers = Hudson.getInstance().getExtensionList(CredentialsProvider.class);
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
        LinkedHashSet<CredentialsScope> result = null;
        for (CredentialsProvider provider : providers) {
            try {
                Set<CredentialsScope> scopes = provider.getScopes(object);
                if (scopes == null) continue;
                if (result == null) {
                    result = new LinkedHashSet<CredentialsScope>();
                }
                result.addAll(scopes);
            }
            catch (NoClassDefFoundError e) {}
        }
        return result;
    }

    public static Iterable<CredentialsStore> lookupStores(final ModelObject object) {
        ExtensionList providers;
        try {
            providers = Hudson.getInstance().getExtensionList(CredentialsProvider.class);
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
        return new Iterable<CredentialsStore>(){

            @Override
            public Iterator<CredentialsStore> iterator() {
                return new Iterator<CredentialsStore>(){
                    private ModelObject current;
                    private Iterator<CredentialsProvider> iterator;
                    private CredentialsStore next;
                    {
                        this.current = object;
                        this.iterator = providers.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next != null) {
                            return true;
                        }
                        while (this.current != null) {
                            while (this.iterator.hasNext()) {
                                CredentialsProvider p = this.iterator.next();
                                this.next = p.getStore(this.current);
                                if (this.next == null) continue;
                                return true;
                            }
                            if (this.current instanceof Item) {
                                this.current = ((Item)this.current).getParent();
                                this.iterator = providers.iterator();
                                continue;
                            }
                            if (!(this.current instanceof Jenkins)) continue;
                            this.current = null;
                        }
                        return false;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public CredentialsStore next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        try {
                            CredentialsStore credentialsStore = this.next;
                            return credentialsStore;
                        }
                        finally {
                            this.next = null;
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <C extends Credentials> C snapshot(C credential) {
        return (C)CredentialsProvider.snapshot(Credentials.class, credential);
    }

    public static <C extends Credentials> C snapshot(Class<C> clazz, C credential) {
        Class bestType = null;
        CredentialsSnapshotTaker bestTaker = null;
        for (CredentialsSnapshotTaker taker : Jenkins.getInstance().getExtensionList(CredentialsSnapshotTaker.class)) {
            if (!clazz.isAssignableFrom(taker.type()) || !taker.type().isInstance(credential) || bestTaker != null && !bestType.isAssignableFrom(taker.type())) continue;
            bestTaker = taker;
            bestType = taker.type();
        }
        if (bestTaker == null) {
            return credential;
        }
        return (C)((Credentials)clazz.cast(bestTaker.snapshot(credential)));
    }
}

