/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.NameWith;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CredentialsNameProvider<C extends Credentials> {
    @NonNull
    public abstract String getName(@NonNull C var1);

    @NonNull
    public static String name(@NonNull Credentials credentials) {
        credentials.getClass();
        NameWith nameWith = credentials.getClass().getAnnotation(NameWith.class);
        if (!CredentialsNameProvider.isValidNameWithAnnotation(nameWith)) {
            LinkedList queue = new LinkedList();
            queue.addAll(Arrays.asList(credentials.getClass().getInterfaces()));
            while (!queue.isEmpty()) {
                NameWith annotation;
                Class interfaze = (Class)queue.remove();
                if (interfaze.getInterfaces().length > 0) {
                    queue.addAll(Arrays.asList(interfaze.getInterfaces()));
                }
                if (!CredentialsNameProvider.isValidNameWithAnnotation(annotation = interfaze.getAnnotation(NameWith.class)) || nameWith != null && nameWith.priority() >= annotation.priority()) continue;
                nameWith = annotation;
            }
        }
        if (CredentialsNameProvider.isValidNameWithAnnotation(nameWith)) {
            try {
                CredentialsNameProvider<? extends Credentials> nameProvider = nameWith.value().newInstance();
                return nameProvider.getName(credentials);
            }
            catch (ClassCastException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        try {
            return credentials.getDescriptor().getDisplayName();
        }
        catch (AssertionError e) {
            return credentials.getClass().getSimpleName();
        }
    }

    private static boolean isValidNameWithAnnotation(@CheckForNull NameWith nameWith) {
        return nameWith != null && nameWith.value() != null;
    }
}

