/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.credentialsbinding.masking;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.Collection;
import java.util.Collections;
import org.jenkinsci.plugins.credentialsbinding.masking.SecretPatternFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class AlmquistShellSecretPatternFactory
implements SecretPatternFactory {
    private static final char SINGLE_QUOTE = '\'';
    private static final String START_FRAGMENT = "'\"";
    private static final String END_FRAGMENT = "\"'";

    @NonNull
    private String getQuotedForm(@NonNull String input) {
        StringBuilder sb = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\'') {
                sb.append(START_FRAGMENT);
                sb.append('\'');
                for (int j = i + 1; j < input.length() && input.charAt(j) == '\''; ++j) {
                    sb.append('\'');
                    ++i;
                }
                sb.append(END_FRAGMENT);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    @NonNull
    public Collection<String> getEncodedForms(@NonNull String input) {
        return Collections.singleton(this.getQuotedForm(input));
    }
}

