/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.credentialsbinding.masking;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import org.jenkinsci.plugins.credentialsbinding.masking.SecretPatternFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class Base64SecretPatternFactory
implements SecretPatternFactory {
    @Override
    @NonNull
    public Collection<String> getEncodedForms(@NonNull String input) {
        return this.getBase64Forms(input);
    }

    @NonNull
    public Collection<String> getBase64Forms(@NonNull String secret) {
        String[] shifts;
        if (secret.length() == 0) {
            return Collections.emptyList();
        }
        Base64.Encoder[] encoders = new Base64.Encoder[]{Base64.getEncoder(), Base64.getUrlEncoder()};
        ArrayList<String> result = new ArrayList<String>();
        for (String shift : shifts = new String[]{"", "a", "aa"}) {
            for (Base64.Encoder encoder : encoders) {
                String shiftedSecret = shift + secret;
                String encoded = encoder.encodeToString(shiftedSecret.getBytes(StandardCharsets.UTF_8));
                String processedEncoded = shift.length() > 0 ? encoded.substring(2 * shift.length()) : encoded;
                result.add(processedEncoded);
                result.add(this.removeTrailingEquals(processedEncoded));
            }
        }
        return result;
    }

    private String removeTrailingEquals(String base64Value) {
        if (base64Value.endsWith("==")) {
            return base64Value.substring(0, base64Value.length() - 3);
        }
        if (base64Value.endsWith("=")) {
            return base64Value.substring(0, base64Value.length() - 2);
        }
        return base64Value;
    }
}

