/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.credentialsbinding.masking;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.ExtensionList;
import hudson.console.LineTransformationOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jenkins.util.JenkinsJVM;
import org.jenkinsci.plugins.credentialsbinding.masking.SecretPatternFactory;

public class SecretPatterns {
    private static final Comparator<String> BY_LENGTH_DESCENDING = Comparator.comparingInt(String::length).reversed().thenComparing(String::compareTo);

    @NonNull
    public static Pattern getAggregateSecretPattern(@NonNull Collection<String> inputs) {
        JenkinsJVM.checkJenkinsJVM();
        ExtensionList<SecretPatternFactory> secretPatternFactories = SecretPatternFactory.all();
        String pattern = inputs.stream().filter(input -> !input.isEmpty()).flatMap(input -> secretPatternFactories.stream().flatMap(factory -> factory.getEncodedForms((String)input).stream())).sorted(BY_LENGTH_DESCENDING).distinct().map(Pattern::quote).collect(Collectors.joining("|"));
        return Pattern.compile(pattern);
    }

    private SecretPatterns() {
    }

    public static class MaskingOutputStream
    extends LineTransformationOutputStream.Delegating {
        @NonNull
        private final Supplier<Pattern> secretPattern;
        @NonNull
        private final String charsetName;
        @Nullable
        private Pattern p;

        public MaskingOutputStream(@NonNull OutputStream out, @NonNull Supplier<Pattern> secretPattern, @NonNull String charsetName) {
            super(out);
            this.secretPattern = secretPattern;
            this.charsetName = charsetName;
        }

        protected void eol(byte[] b, int len) throws IOException {
            if (this.p == null) {
                this.p = this.secretPattern.get();
            }
            if (this.p == null || this.p.toString().isEmpty()) {
                this.out.write(b, 0, len);
            } else {
                Matcher m = this.p.matcher(new String(b, 0, len, this.charsetName));
                if (m.find()) {
                    this.out.write(m.replaceAll("****").getBytes(this.charsetName));
                } else {
                    this.out.write(b, 0, len);
                }
            }
        }

        public String toString() {
            return "MaskingOutputStream[" + this.out + "]";
        }
    }
}

