/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.credentialsbinding.impl;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.CredentialNotFoundException;
import org.jenkinsci.plugins.credentialsbinding.impl.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class UsernamePasswordMultiBinding
extends MultiBinding<StandardUsernamePasswordCredentials> {
    private final String usernameVariable;
    private final String passwordVariable;

    @DataBoundConstructor
    public UsernamePasswordMultiBinding(String usernameVariable, String passwordVariable, String credentialsId) {
        super(credentialsId);
        this.usernameVariable = usernameVariable;
        this.passwordVariable = passwordVariable;
    }

    public String getUsernameVariable() {
        return this.usernameVariable;
    }

    public String getPasswordVariable() {
        return this.passwordVariable;
    }

    @Override
    protected Class<StandardUsernamePasswordCredentials> type() {
        return StandardUsernamePasswordCredentials.class;
    }

    @Override
    public MultiBinding.MultiEnvironment bind(@NonNull Run<?, ?> build, @Nullable FilePath workspace, @Nullable Launcher launcher, @NonNull TaskListener listener) throws IOException, InterruptedException {
        StandardUsernamePasswordCredentials credentials = (StandardUsernamePasswordCredentials)this.getCredentials(build);
        LinkedHashMap<String, String> secretValues = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> publicValues = new LinkedHashMap<String, String>();
        (credentials.isUsernameSecret() ? secretValues : publicValues).put(this.usernameVariable, credentials.getUsername());
        secretValues.put(this.passwordVariable, credentials.getPassword().getPlainText());
        return new MultiBinding.MultiEnvironment(secretValues, publicValues);
    }

    @Override
    public Set<String> variables(@NonNull Run<?, ?> build) throws CredentialNotFoundException {
        StandardUsernamePasswordCredentials credentials = (StandardUsernamePasswordCredentials)this.getCredentials(build);
        LinkedHashSet<String> vars = new LinkedHashSet<String>();
        if (credentials.isUsernameSecret()) {
            vars.add(this.usernameVariable);
        }
        vars.add(this.passwordVariable);
        return vars;
    }

    @Symbol(value={"usernamePassword"})
    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<StandardUsernamePasswordCredentials> {
        @Override
        protected Class<StandardUsernamePasswordCredentials> type() {
            return StandardUsernamePasswordCredentials.class;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.UsernamePasswordMultiBinding_username_and_password();
        }

        @Override
        public boolean requiresWorkspace() {
            return false;
        }
    }
}

